/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iot.model.IoTRequest;
import software.amazon.awssdk.services.iot.model.TopicRulePayload;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateTopicRuleRequest
extends IoTRequest
implements ToCopyableBuilder<Builder, CreateTopicRuleRequest> {
    private final String ruleName;
    private final TopicRulePayload topicRulePayload;

    private CreateTopicRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.topicRulePayload = builder.topicRulePayload;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public TopicRulePayload topicRulePayload() {
        return this.topicRulePayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicRulePayload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTopicRuleRequest)) {
            return false;
        }
        CreateTopicRuleRequest other = (CreateTopicRuleRequest)((Object)obj);
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.topicRulePayload(), other.topicRulePayload());
    }

    public String toString() {
        return ToString.builder((String)"CreateTopicRuleRequest").add("RuleName", (Object)this.ruleName()).add("TopicRulePayload", (Object)this.topicRulePayload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleName": {
                return Optional.of(clazz.cast(this.ruleName()));
            }
            case "topicRulePayload": {
                return Optional.of(clazz.cast(this.topicRulePayload()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTRequest.BuilderImpl
    implements Builder {
        private String ruleName;
        private TopicRulePayload topicRulePayload;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTopicRuleRequest model) {
            super(model);
            this.ruleName(model.ruleName);
            this.topicRulePayload(model.topicRulePayload);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final TopicRulePayload.Builder getTopicRulePayload() {
            return this.topicRulePayload != null ? this.topicRulePayload.toBuilder() : null;
        }

        @Override
        public final Builder topicRulePayload(TopicRulePayload topicRulePayload) {
            this.topicRulePayload = topicRulePayload;
            return this;
        }

        public final void setTopicRulePayload(TopicRulePayload.BuilderImpl topicRulePayload) {
            this.topicRulePayload = topicRulePayload != null ? topicRulePayload.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateTopicRuleRequest build() {
            return new CreateTopicRuleRequest(this);
        }
    }

    public static interface Builder
    extends IoTRequest.Builder,
    CopyableBuilder<Builder, CreateTopicRuleRequest> {
        public Builder ruleName(String var1);

        public Builder topicRulePayload(TopicRulePayload var1);

        default public Builder topicRulePayload(Consumer<TopicRulePayload.Builder> topicRulePayload) {
            return this.topicRulePayload((TopicRulePayload)((TopicRulePayload.Builder)TopicRulePayload.builder().apply(topicRulePayload)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

