/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.iot.transform.TransferDataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TransferData
implements StructuredPojo,
ToCopyableBuilder<Builder, TransferData> {
    private final String transferMessage;
    private final String rejectReason;
    private final Date transferDate;
    private final Date acceptDate;
    private final Date rejectDate;

    private TransferData(BuilderImpl builder) {
        this.transferMessage = builder.transferMessage;
        this.rejectReason = builder.rejectReason;
        this.transferDate = builder.transferDate;
        this.acceptDate = builder.acceptDate;
        this.rejectDate = builder.rejectDate;
    }

    public String transferMessage() {
        return this.transferMessage;
    }

    public String rejectReason() {
        return this.rejectReason;
    }

    public Date transferDate() {
        return this.transferDate;
    }

    public Date acceptDate() {
        return this.acceptDate;
    }

    public Date rejectDate() {
        return this.rejectDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.transferMessage() == null ? 0 : this.transferMessage().hashCode());
        hashCode = 31 * hashCode + (this.rejectReason() == null ? 0 : this.rejectReason().hashCode());
        hashCode = 31 * hashCode + (this.transferDate() == null ? 0 : this.transferDate().hashCode());
        hashCode = 31 * hashCode + (this.acceptDate() == null ? 0 : this.acceptDate().hashCode());
        hashCode = 31 * hashCode + (this.rejectDate() == null ? 0 : this.rejectDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferData)) {
            return false;
        }
        TransferData other = (TransferData)obj;
        if (other.transferMessage() == null ^ this.transferMessage() == null) {
            return false;
        }
        if (other.transferMessage() != null && !other.transferMessage().equals(this.transferMessage())) {
            return false;
        }
        if (other.rejectReason() == null ^ this.rejectReason() == null) {
            return false;
        }
        if (other.rejectReason() != null && !other.rejectReason().equals(this.rejectReason())) {
            return false;
        }
        if (other.transferDate() == null ^ this.transferDate() == null) {
            return false;
        }
        if (other.transferDate() != null && !other.transferDate().equals(this.transferDate())) {
            return false;
        }
        if (other.acceptDate() == null ^ this.acceptDate() == null) {
            return false;
        }
        if (other.acceptDate() != null && !other.acceptDate().equals(this.acceptDate())) {
            return false;
        }
        if (other.rejectDate() == null ^ this.rejectDate() == null) {
            return false;
        }
        return other.rejectDate() == null || other.rejectDate().equals(this.rejectDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.transferMessage() != null) {
            sb.append("TransferMessage: ").append(this.transferMessage()).append(",");
        }
        if (this.rejectReason() != null) {
            sb.append("RejectReason: ").append(this.rejectReason()).append(",");
        }
        if (this.transferDate() != null) {
            sb.append("TransferDate: ").append(this.transferDate()).append(",");
        }
        if (this.acceptDate() != null) {
            sb.append("AcceptDate: ").append(this.acceptDate()).append(",");
        }
        if (this.rejectDate() != null) {
            sb.append("RejectDate: ").append(this.rejectDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TransferDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String transferMessage;
        private String rejectReason;
        private Date transferDate;
        private Date acceptDate;
        private Date rejectDate;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferData model) {
            this.setTransferMessage(model.transferMessage);
            this.setRejectReason(model.rejectReason);
            this.setTransferDate(model.transferDate);
            this.setAcceptDate(model.acceptDate);
            this.setRejectDate(model.rejectDate);
        }

        public final String getTransferMessage() {
            return this.transferMessage;
        }

        @Override
        public final Builder transferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
            return this;
        }

        public final void setTransferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
        }

        public final String getRejectReason() {
            return this.rejectReason;
        }

        @Override
        public final Builder rejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
            return this;
        }

        public final void setRejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
        }

        public final Date getTransferDate() {
            return this.transferDate;
        }

        @Override
        public final Builder transferDate(Date transferDate) {
            this.transferDate = StandardMemberCopier.copy((Date)transferDate);
            return this;
        }

        public final void setTransferDate(Date transferDate) {
            this.transferDate = StandardMemberCopier.copy((Date)transferDate);
        }

        public final Date getAcceptDate() {
            return this.acceptDate;
        }

        @Override
        public final Builder acceptDate(Date acceptDate) {
            this.acceptDate = StandardMemberCopier.copy((Date)acceptDate);
            return this;
        }

        public final void setAcceptDate(Date acceptDate) {
            this.acceptDate = StandardMemberCopier.copy((Date)acceptDate);
        }

        public final Date getRejectDate() {
            return this.rejectDate;
        }

        @Override
        public final Builder rejectDate(Date rejectDate) {
            this.rejectDate = StandardMemberCopier.copy((Date)rejectDate);
            return this;
        }

        public final void setRejectDate(Date rejectDate) {
            this.rejectDate = StandardMemberCopier.copy((Date)rejectDate);
        }

        public TransferData build() {
            return new TransferData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TransferData> {
        public Builder transferMessage(String var1);

        public Builder rejectReason(String var1);

        public Builder transferDate(Date var1);

        public Builder acceptDate(Date var1);

        public Builder rejectDate(Date var1);
    }
}

