/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.iot.transform.TopicRuleListItemMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TopicRuleListItem
implements StructuredPojo,
ToCopyableBuilder<Builder, TopicRuleListItem> {
    private final String ruleArn;
    private final String ruleName;
    private final String topicPattern;
    private final Date createdAt;
    private final Boolean ruleDisabled;

    private TopicRuleListItem(BuilderImpl builder) {
        this.ruleArn = builder.ruleArn;
        this.ruleName = builder.ruleName;
        this.topicPattern = builder.topicPattern;
        this.createdAt = builder.createdAt;
        this.ruleDisabled = builder.ruleDisabled;
    }

    public String ruleArn() {
        return this.ruleArn;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public String topicPattern() {
        return this.topicPattern;
    }

    public Date createdAt() {
        return this.createdAt;
    }

    public Boolean ruleDisabled() {
        return this.ruleDisabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ruleArn() == null ? 0 : this.ruleArn().hashCode());
        hashCode = 31 * hashCode + (this.ruleName() == null ? 0 : this.ruleName().hashCode());
        hashCode = 31 * hashCode + (this.topicPattern() == null ? 0 : this.topicPattern().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.ruleDisabled() == null ? 0 : this.ruleDisabled().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRuleListItem)) {
            return false;
        }
        TopicRuleListItem other = (TopicRuleListItem)obj;
        if (other.ruleArn() == null ^ this.ruleArn() == null) {
            return false;
        }
        if (other.ruleArn() != null && !other.ruleArn().equals(this.ruleArn())) {
            return false;
        }
        if (other.ruleName() == null ^ this.ruleName() == null) {
            return false;
        }
        if (other.ruleName() != null && !other.ruleName().equals(this.ruleName())) {
            return false;
        }
        if (other.topicPattern() == null ^ this.topicPattern() == null) {
            return false;
        }
        if (other.topicPattern() != null && !other.topicPattern().equals(this.topicPattern())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.ruleDisabled() == null ^ this.ruleDisabled() == null) {
            return false;
        }
        return other.ruleDisabled() == null || other.ruleDisabled().equals(this.ruleDisabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ruleArn() != null) {
            sb.append("RuleArn: ").append(this.ruleArn()).append(",");
        }
        if (this.ruleName() != null) {
            sb.append("RuleName: ").append(this.ruleName()).append(",");
        }
        if (this.topicPattern() != null) {
            sb.append("TopicPattern: ").append(this.topicPattern()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.ruleDisabled() != null) {
            sb.append("RuleDisabled: ").append(this.ruleDisabled()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicRuleListItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String ruleArn;
        private String ruleName;
        private String topicPattern;
        private Date createdAt;
        private Boolean ruleDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRuleListItem model) {
            this.setRuleArn(model.ruleArn);
            this.setRuleName(model.ruleName);
            this.setTopicPattern(model.topicPattern);
            this.setCreatedAt(model.createdAt);
            this.setRuleDisabled(model.ruleDisabled);
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getTopicPattern() {
            return this.topicPattern;
        }

        @Override
        public final Builder topicPattern(String topicPattern) {
            this.topicPattern = topicPattern;
            return this;
        }

        public final void setTopicPattern(String topicPattern) {
            this.topicPattern = topicPattern;
        }

        public final Date getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Date createdAt) {
            this.createdAt = StandardMemberCopier.copy((Date)createdAt);
            return this;
        }

        public final void setCreatedAt(Date createdAt) {
            this.createdAt = StandardMemberCopier.copy((Date)createdAt);
        }

        public final Boolean getRuleDisabled() {
            return this.ruleDisabled;
        }

        @Override
        public final Builder ruleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
            return this;
        }

        public final void setRuleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
        }

        public TopicRuleListItem build() {
            return new TopicRuleListItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TopicRuleListItem> {
        public Builder ruleArn(String var1);

        public Builder ruleName(String var1);

        public Builder topicPattern(String var1);

        public Builder createdAt(Date var1);

        public Builder ruleDisabled(Boolean var1);
    }
}

