/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.iot.model.ThingAttribute;
import software.amazon.awssdk.services.iot.model.ThingAttributeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListThingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListThingsResponse> {
    private final List<ThingAttribute> things;
    private final String nextToken;

    private ListThingsResponse(BuilderImpl builder) {
        this.things = builder.things;
        this.nextToken = builder.nextToken;
    }

    public List<ThingAttribute> things() {
        return this.things;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.things() == null ? 0 : this.things().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingsResponse)) {
            return false;
        }
        ListThingsResponse other = (ListThingsResponse)((Object)obj);
        if (other.things() == null ^ this.things() == null) {
            return false;
        }
        if (other.things() != null && !other.things().equals(this.things())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.things() != null) {
            sb.append("Things: ").append(this.things()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ThingAttribute> things;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingsResponse model) {
            this.setThings(model.things);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ThingAttribute> getThings() {
            return this.things;
        }

        @Override
        public final Builder things(Collection<ThingAttribute> things) {
            this.things = ThingAttributeListCopier.copy(things);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(ThingAttribute ... things) {
            if (this.things == null) {
                this.things = new ArrayList<ThingAttribute>(things.length);
            }
            for (ThingAttribute e : things) {
                this.things.add(e);
            }
            return this;
        }

        public final void setThings(Collection<ThingAttribute> things) {
            this.things = ThingAttributeListCopier.copy(things);
        }

        @SafeVarargs
        public final void setThings(ThingAttribute ... things) {
            if (this.things == null) {
                this.things = new ArrayList<ThingAttribute>(things.length);
            }
            for (ThingAttribute e : things) {
                this.things.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListThingsResponse build() {
            return new ListThingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListThingsResponse> {
        public Builder things(Collection<ThingAttribute> var1);

        public Builder things(ThingAttribute ... var1);

        public Builder nextToken(String var1);
    }
}

