/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.KinesisActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KinesisAction
implements StructuredPojo,
ToCopyableBuilder<Builder, KinesisAction> {
    private final String roleArn;
    private final String streamName;
    private final String partitionKey;

    private KinesisAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.streamName = builder.streamName;
        this.partitionKey = builder.partitionKey;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String streamName() {
        return this.streamName;
    }

    public String partitionKey() {
        return this.partitionKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        hashCode = 31 * hashCode + (this.streamName() == null ? 0 : this.streamName().hashCode());
        hashCode = 31 * hashCode + (this.partitionKey() == null ? 0 : this.partitionKey().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisAction)) {
            return false;
        }
        KinesisAction other = (KinesisAction)obj;
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.partitionKey() == null ^ this.partitionKey() == null) {
            return false;
        }
        return other.partitionKey() == null || other.partitionKey().equals(this.partitionKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.partitionKey() != null) {
            sb.append("PartitionKey: ").append(this.partitionKey()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String streamName;
        private String partitionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisAction model) {
            this.setRoleArn(model.roleArn);
            this.setStreamName(model.streamName);
            this.setPartitionKey(model.partitionKey);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public KinesisAction build() {
            return new KinesisAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KinesisAction> {
        public Builder roleArn(String var1);

        public Builder streamName(String var1);

        public Builder partitionKey(String var1);
    }
}

