/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.iot.model.AttributePayload;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateThingRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateThingRequest> {
    private final String thingName;
    private final String thingTypeName;
    private final AttributePayload attributePayload;

    private CreateThingRequest(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.attributePayload = builder.attributePayload;
    }

    public String thingName() {
        return this.thingName;
    }

    public String thingTypeName() {
        return this.thingTypeName;
    }

    public AttributePayload attributePayload() {
        return this.attributePayload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.thingName() == null ? 0 : this.thingName().hashCode());
        hashCode = 31 * hashCode + (this.thingTypeName() == null ? 0 : this.thingTypeName().hashCode());
        hashCode = 31 * hashCode + (this.attributePayload() == null ? 0 : this.attributePayload().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingRequest)) {
            return false;
        }
        CreateThingRequest other = (CreateThingRequest)((Object)obj);
        if (other.thingName() == null ^ this.thingName() == null) {
            return false;
        }
        if (other.thingName() != null && !other.thingName().equals(this.thingName())) {
            return false;
        }
        if (other.thingTypeName() == null ^ this.thingTypeName() == null) {
            return false;
        }
        if (other.thingTypeName() != null && !other.thingTypeName().equals(this.thingTypeName())) {
            return false;
        }
        if (other.attributePayload() == null ^ this.attributePayload() == null) {
            return false;
        }
        return other.attributePayload() == null || other.attributePayload().equals(this.attributePayload());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.thingName() != null) {
            sb.append("ThingName: ").append(this.thingName()).append(",");
        }
        if (this.thingTypeName() != null) {
            sb.append("ThingTypeName: ").append(this.thingTypeName()).append(",");
        }
        if (this.attributePayload() != null) {
            sb.append("AttributePayload: ").append(this.attributePayload()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String thingName;
        private String thingTypeName;
        private AttributePayload attributePayload;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingRequest model) {
            this.setThingName(model.thingName);
            this.setThingTypeName(model.thingTypeName);
            this.setAttributePayload(model.attributePayload);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final AttributePayload getAttributePayload() {
            return this.attributePayload;
        }

        @Override
        public final Builder attributePayload(AttributePayload attributePayload) {
            this.attributePayload = attributePayload;
            return this;
        }

        public final void setAttributePayload(AttributePayload attributePayload) {
            this.attributePayload = attributePayload;
        }

        public CreateThingRequest build() {
            return new CreateThingRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateThingRequest> {
        public Builder thingName(String var1);

        public Builder thingTypeName(String var1);

        public Builder attributePayload(AttributePayload var1);
    }
}

