/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.invoicing.model.BuyerDomain;
import software.amazon.awssdk.services.invoicing.model.SupplierDomain;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestEnvPreference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestEnvPreference> {
    private static final SdkField<String> BUYER_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuyerDomain").getter(TestEnvPreference.getter(TestEnvPreference::buyerDomainAsString)).setter(TestEnvPreference.setter(Builder::buyerDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerDomain").build()}).build();
    private static final SdkField<String> BUYER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuyerIdentifier").getter(TestEnvPreference.getter(TestEnvPreference::buyerIdentifier)).setter(TestEnvPreference.setter(Builder::buyerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerIdentifier").build()}).build();
    private static final SdkField<String> SUPPLIER_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupplierDomain").getter(TestEnvPreference.getter(TestEnvPreference::supplierDomainAsString)).setter(TestEnvPreference.setter(Builder::supplierDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplierDomain").build()}).build();
    private static final SdkField<String> SUPPLIER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupplierIdentifier").getter(TestEnvPreference.getter(TestEnvPreference::supplierIdentifier)).setter(TestEnvPreference.setter(Builder::supplierIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplierIdentifier").build()}).build();
    private static final SdkField<String> PROCUREMENT_PORTAL_SHARED_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcurementPortalSharedSecret").getter(TestEnvPreference.getter(TestEnvPreference::procurementPortalSharedSecret)).setter(TestEnvPreference.setter(Builder::procurementPortalSharedSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalSharedSecret").build()}).build();
    private static final SdkField<String> PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcurementPortalInstanceEndpoint").getter(TestEnvPreference.getter(TestEnvPreference::procurementPortalInstanceEndpoint)).setter(TestEnvPreference.setter(Builder::procurementPortalInstanceEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalInstanceEndpoint").build()}).build();
    private static final SdkField<String> PURCHASE_ORDER_RETRIEVAL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PurchaseOrderRetrievalEndpoint").getter(TestEnvPreference.getter(TestEnvPreference::purchaseOrderRetrievalEndpoint)).setter(TestEnvPreference.setter(Builder::purchaseOrderRetrievalEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderRetrievalEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUYER_DOMAIN_FIELD, BUYER_IDENTIFIER_FIELD, SUPPLIER_DOMAIN_FIELD, SUPPLIER_IDENTIFIER_FIELD, PROCUREMENT_PORTAL_SHARED_SECRET_FIELD, PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD, PURCHASE_ORDER_RETRIEVAL_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestEnvPreference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String buyerDomain;
    private final String buyerIdentifier;
    private final String supplierDomain;
    private final String supplierIdentifier;
    private final String procurementPortalSharedSecret;
    private final String procurementPortalInstanceEndpoint;
    private final String purchaseOrderRetrievalEndpoint;

    private TestEnvPreference(BuilderImpl builder) {
        this.buyerDomain = builder.buyerDomain;
        this.buyerIdentifier = builder.buyerIdentifier;
        this.supplierDomain = builder.supplierDomain;
        this.supplierIdentifier = builder.supplierIdentifier;
        this.procurementPortalSharedSecret = builder.procurementPortalSharedSecret;
        this.procurementPortalInstanceEndpoint = builder.procurementPortalInstanceEndpoint;
        this.purchaseOrderRetrievalEndpoint = builder.purchaseOrderRetrievalEndpoint;
    }

    public final BuyerDomain buyerDomain() {
        return BuyerDomain.fromValue(this.buyerDomain);
    }

    public final String buyerDomainAsString() {
        return this.buyerDomain;
    }

    public final String buyerIdentifier() {
        return this.buyerIdentifier;
    }

    public final SupplierDomain supplierDomain() {
        return SupplierDomain.fromValue(this.supplierDomain);
    }

    public final String supplierDomainAsString() {
        return this.supplierDomain;
    }

    public final String supplierIdentifier() {
        return this.supplierIdentifier;
    }

    public final String procurementPortalSharedSecret() {
        return this.procurementPortalSharedSecret;
    }

    public final String procurementPortalInstanceEndpoint() {
        return this.procurementPortalInstanceEndpoint;
    }

    public final String purchaseOrderRetrievalEndpoint() {
        return this.purchaseOrderRetrievalEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.buyerDomainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.buyerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplierDomainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplierIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.procurementPortalSharedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.procurementPortalInstanceEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseOrderRetrievalEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestEnvPreference)) {
            return false;
        }
        TestEnvPreference other = (TestEnvPreference)obj;
        return Objects.equals(this.buyerDomainAsString(), other.buyerDomainAsString()) && Objects.equals(this.buyerIdentifier(), other.buyerIdentifier()) && Objects.equals(this.supplierDomainAsString(), other.supplierDomainAsString()) && Objects.equals(this.supplierIdentifier(), other.supplierIdentifier()) && Objects.equals(this.procurementPortalSharedSecret(), other.procurementPortalSharedSecret()) && Objects.equals(this.procurementPortalInstanceEndpoint(), other.procurementPortalInstanceEndpoint()) && Objects.equals(this.purchaseOrderRetrievalEndpoint(), other.purchaseOrderRetrievalEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"TestEnvPreference").add("BuyerDomain", (Object)this.buyerDomainAsString()).add("BuyerIdentifier", (Object)this.buyerIdentifier()).add("SupplierDomain", (Object)this.supplierDomainAsString()).add("SupplierIdentifier", (Object)this.supplierIdentifier()).add("ProcurementPortalSharedSecret", (Object)this.procurementPortalSharedSecret()).add("ProcurementPortalInstanceEndpoint", (Object)this.procurementPortalInstanceEndpoint()).add("PurchaseOrderRetrievalEndpoint", (Object)this.purchaseOrderRetrievalEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BuyerDomain": {
                return Optional.ofNullable(clazz.cast(this.buyerDomainAsString()));
            }
            case "BuyerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.buyerIdentifier()));
            }
            case "SupplierDomain": {
                return Optional.ofNullable(clazz.cast(this.supplierDomainAsString()));
            }
            case "SupplierIdentifier": {
                return Optional.ofNullable(clazz.cast(this.supplierIdentifier()));
            }
            case "ProcurementPortalSharedSecret": {
                return Optional.ofNullable(clazz.cast(this.procurementPortalSharedSecret()));
            }
            case "ProcurementPortalInstanceEndpoint": {
                return Optional.ofNullable(clazz.cast(this.procurementPortalInstanceEndpoint()));
            }
            case "PurchaseOrderRetrievalEndpoint": {
                return Optional.ofNullable(clazz.cast(this.purchaseOrderRetrievalEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BuyerDomain", BUYER_DOMAIN_FIELD);
        map.put("BuyerIdentifier", BUYER_IDENTIFIER_FIELD);
        map.put("SupplierDomain", SUPPLIER_DOMAIN_FIELD);
        map.put("SupplierIdentifier", SUPPLIER_IDENTIFIER_FIELD);
        map.put("ProcurementPortalSharedSecret", PROCUREMENT_PORTAL_SHARED_SECRET_FIELD);
        map.put("ProcurementPortalInstanceEndpoint", PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD);
        map.put("PurchaseOrderRetrievalEndpoint", PURCHASE_ORDER_RETRIEVAL_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestEnvPreference, T> g) {
        return obj -> g.apply((TestEnvPreference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String buyerDomain;
        private String buyerIdentifier;
        private String supplierDomain;
        private String supplierIdentifier;
        private String procurementPortalSharedSecret;
        private String procurementPortalInstanceEndpoint;
        private String purchaseOrderRetrievalEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(TestEnvPreference model) {
            this.buyerDomain(model.buyerDomain);
            this.buyerIdentifier(model.buyerIdentifier);
            this.supplierDomain(model.supplierDomain);
            this.supplierIdentifier(model.supplierIdentifier);
            this.procurementPortalSharedSecret(model.procurementPortalSharedSecret);
            this.procurementPortalInstanceEndpoint(model.procurementPortalInstanceEndpoint);
            this.purchaseOrderRetrievalEndpoint(model.purchaseOrderRetrievalEndpoint);
        }

        public final String getBuyerDomain() {
            return this.buyerDomain;
        }

        public final void setBuyerDomain(String buyerDomain) {
            this.buyerDomain = buyerDomain;
        }

        @Override
        public final Builder buyerDomain(String buyerDomain) {
            this.buyerDomain = buyerDomain;
            return this;
        }

        @Override
        public final Builder buyerDomain(BuyerDomain buyerDomain) {
            this.buyerDomain(buyerDomain == null ? null : buyerDomain.toString());
            return this;
        }

        public final String getBuyerIdentifier() {
            return this.buyerIdentifier;
        }

        public final void setBuyerIdentifier(String buyerIdentifier) {
            this.buyerIdentifier = buyerIdentifier;
        }

        @Override
        public final Builder buyerIdentifier(String buyerIdentifier) {
            this.buyerIdentifier = buyerIdentifier;
            return this;
        }

        public final String getSupplierDomain() {
            return this.supplierDomain;
        }

        public final void setSupplierDomain(String supplierDomain) {
            this.supplierDomain = supplierDomain;
        }

        @Override
        public final Builder supplierDomain(String supplierDomain) {
            this.supplierDomain = supplierDomain;
            return this;
        }

        @Override
        public final Builder supplierDomain(SupplierDomain supplierDomain) {
            this.supplierDomain(supplierDomain == null ? null : supplierDomain.toString());
            return this;
        }

        public final String getSupplierIdentifier() {
            return this.supplierIdentifier;
        }

        public final void setSupplierIdentifier(String supplierIdentifier) {
            this.supplierIdentifier = supplierIdentifier;
        }

        @Override
        public final Builder supplierIdentifier(String supplierIdentifier) {
            this.supplierIdentifier = supplierIdentifier;
            return this;
        }

        public final String getProcurementPortalSharedSecret() {
            return this.procurementPortalSharedSecret;
        }

        public final void setProcurementPortalSharedSecret(String procurementPortalSharedSecret) {
            this.procurementPortalSharedSecret = procurementPortalSharedSecret;
        }

        @Override
        public final Builder procurementPortalSharedSecret(String procurementPortalSharedSecret) {
            this.procurementPortalSharedSecret = procurementPortalSharedSecret;
            return this;
        }

        public final String getProcurementPortalInstanceEndpoint() {
            return this.procurementPortalInstanceEndpoint;
        }

        public final void setProcurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint) {
            this.procurementPortalInstanceEndpoint = procurementPortalInstanceEndpoint;
        }

        @Override
        public final Builder procurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint) {
            this.procurementPortalInstanceEndpoint = procurementPortalInstanceEndpoint;
            return this;
        }

        public final String getPurchaseOrderRetrievalEndpoint() {
            return this.purchaseOrderRetrievalEndpoint;
        }

        public final void setPurchaseOrderRetrievalEndpoint(String purchaseOrderRetrievalEndpoint) {
            this.purchaseOrderRetrievalEndpoint = purchaseOrderRetrievalEndpoint;
        }

        @Override
        public final Builder purchaseOrderRetrievalEndpoint(String purchaseOrderRetrievalEndpoint) {
            this.purchaseOrderRetrievalEndpoint = purchaseOrderRetrievalEndpoint;
            return this;
        }

        public TestEnvPreference build() {
            return new TestEnvPreference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestEnvPreference> {
        public Builder buyerDomain(String var1);

        public Builder buyerDomain(BuyerDomain var1);

        public Builder buyerIdentifier(String var1);

        public Builder supplierDomain(String var1);

        public Builder supplierDomain(SupplierDomain var1);

        public Builder supplierIdentifier(String var1);

        public Builder procurementPortalSharedSecret(String var1);

        public Builder procurementPortalInstanceEndpoint(String var1);

        public Builder purchaseOrderRetrievalEndpoint(String var1);
    }
}

