/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SupplementalDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SupplementalDocument> {
    private static final SdkField<String> DOCUMENT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentUrl").getter(SupplementalDocument.getter(SupplementalDocument::documentUrl)).setter(SupplementalDocument.setter(Builder::documentUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentUrl").build()}).build();
    private static final SdkField<Instant> DOCUMENT_URL_EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DocumentUrlExpirationDate").getter(SupplementalDocument.getter(SupplementalDocument::documentUrlExpirationDate)).setter(SupplementalDocument.setter(Builder::documentUrlExpirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentUrlExpirationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_URL_FIELD, DOCUMENT_URL_EXPIRATION_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SupplementalDocument.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String documentUrl;
    private final Instant documentUrlExpirationDate;

    private SupplementalDocument(BuilderImpl builder) {
        this.documentUrl = builder.documentUrl;
        this.documentUrlExpirationDate = builder.documentUrlExpirationDate;
    }

    public final String documentUrl() {
        return this.documentUrl;
    }

    public final Instant documentUrlExpirationDate() {
        return this.documentUrlExpirationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentUrlExpirationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupplementalDocument)) {
            return false;
        }
        SupplementalDocument other = (SupplementalDocument)obj;
        return Objects.equals(this.documentUrl(), other.documentUrl()) && Objects.equals(this.documentUrlExpirationDate(), other.documentUrlExpirationDate());
    }

    public final String toString() {
        return ToString.builder((String)"SupplementalDocument").add("DocumentUrl", (Object)this.documentUrl()).add("DocumentUrlExpirationDate", (Object)this.documentUrlExpirationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentUrl": {
                return Optional.ofNullable(clazz.cast(this.documentUrl()));
            }
            case "DocumentUrlExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.documentUrlExpirationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DocumentUrl", DOCUMENT_URL_FIELD);
        map.put("DocumentUrlExpirationDate", DOCUMENT_URL_EXPIRATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupplementalDocument, T> g) {
        return obj -> g.apply((SupplementalDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentUrl;
        private Instant documentUrlExpirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SupplementalDocument model) {
            this.documentUrl(model.documentUrl);
            this.documentUrlExpirationDate(model.documentUrlExpirationDate);
        }

        public final String getDocumentUrl() {
            return this.documentUrl;
        }

        public final void setDocumentUrl(String documentUrl) {
            this.documentUrl = documentUrl;
        }

        @Override
        public final Builder documentUrl(String documentUrl) {
            this.documentUrl = documentUrl;
            return this;
        }

        public final Instant getDocumentUrlExpirationDate() {
            return this.documentUrlExpirationDate;
        }

        public final void setDocumentUrlExpirationDate(Instant documentUrlExpirationDate) {
            this.documentUrlExpirationDate = documentUrlExpirationDate;
        }

        @Override
        public final Builder documentUrlExpirationDate(Instant documentUrlExpirationDate) {
            this.documentUrlExpirationDate = documentUrlExpirationDate;
            return this;
        }

        public SupplementalDocument build() {
            return new SupplementalDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SupplementalDocument> {
        public Builder documentUrl(String var1);

        public Builder documentUrlExpirationDate(Instant var1);
    }
}

