/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.invoicing.model.InvoiceUnitArnsCopier;
import software.amazon.awssdk.services.invoicing.model.SellerOfRecordsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcurementPortalPreferenceSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcurementPortalPreferenceSelector> {
    private static final SdkField<List<String>> INVOICE_UNIT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InvoiceUnitArns").getter(ProcurementPortalPreferenceSelector.getter(ProcurementPortalPreferenceSelector::invoiceUnitArns)).setter(ProcurementPortalPreferenceSelector.setter(Builder::invoiceUnitArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceUnitArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SELLER_OF_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SellerOfRecords").getter(ProcurementPortalPreferenceSelector.getter(ProcurementPortalPreferenceSelector::sellerOfRecords)).setter(ProcurementPortalPreferenceSelector.setter(Builder::sellerOfRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SellerOfRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOICE_UNIT_ARNS_FIELD, SELLER_OF_RECORDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProcurementPortalPreferenceSelector.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> invoiceUnitArns;
    private final List<String> sellerOfRecords;

    private ProcurementPortalPreferenceSelector(BuilderImpl builder) {
        this.invoiceUnitArns = builder.invoiceUnitArns;
        this.sellerOfRecords = builder.sellerOfRecords;
    }

    public final boolean hasInvoiceUnitArns() {
        return this.invoiceUnitArns != null && !(this.invoiceUnitArns instanceof SdkAutoConstructList);
    }

    public final List<String> invoiceUnitArns() {
        return this.invoiceUnitArns;
    }

    public final boolean hasSellerOfRecords() {
        return this.sellerOfRecords != null && !(this.sellerOfRecords instanceof SdkAutoConstructList);
    }

    public final List<String> sellerOfRecords() {
        return this.sellerOfRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvoiceUnitArns() ? this.invoiceUnitArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSellerOfRecords() ? this.sellerOfRecords() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcurementPortalPreferenceSelector)) {
            return false;
        }
        ProcurementPortalPreferenceSelector other = (ProcurementPortalPreferenceSelector)obj;
        return this.hasInvoiceUnitArns() == other.hasInvoiceUnitArns() && Objects.equals(this.invoiceUnitArns(), other.invoiceUnitArns()) && this.hasSellerOfRecords() == other.hasSellerOfRecords() && Objects.equals(this.sellerOfRecords(), other.sellerOfRecords());
    }

    public final String toString() {
        return ToString.builder((String)"ProcurementPortalPreferenceSelector").add("InvoiceUnitArns", this.hasInvoiceUnitArns() ? this.invoiceUnitArns() : null).add("SellerOfRecords", this.hasSellerOfRecords() ? this.sellerOfRecords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvoiceUnitArns": {
                return Optional.ofNullable(clazz.cast(this.invoiceUnitArns()));
            }
            case "SellerOfRecords": {
                return Optional.ofNullable(clazz.cast(this.sellerOfRecords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("InvoiceUnitArns", INVOICE_UNIT_ARNS_FIELD);
        map.put("SellerOfRecords", SELLER_OF_RECORDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProcurementPortalPreferenceSelector, T> g) {
        return obj -> g.apply((ProcurementPortalPreferenceSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> invoiceUnitArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> sellerOfRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProcurementPortalPreferenceSelector model) {
            this.invoiceUnitArns(model.invoiceUnitArns);
            this.sellerOfRecords(model.sellerOfRecords);
        }

        public final Collection<String> getInvoiceUnitArns() {
            if (this.invoiceUnitArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.invoiceUnitArns;
        }

        public final void setInvoiceUnitArns(Collection<String> invoiceUnitArns) {
            this.invoiceUnitArns = InvoiceUnitArnsCopier.copy(invoiceUnitArns);
        }

        @Override
        public final Builder invoiceUnitArns(Collection<String> invoiceUnitArns) {
            this.invoiceUnitArns = InvoiceUnitArnsCopier.copy(invoiceUnitArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invoiceUnitArns(String ... invoiceUnitArns) {
            this.invoiceUnitArns(Arrays.asList(invoiceUnitArns));
            return this;
        }

        public final Collection<String> getSellerOfRecords() {
            if (this.sellerOfRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sellerOfRecords;
        }

        public final void setSellerOfRecords(Collection<String> sellerOfRecords) {
            this.sellerOfRecords = SellerOfRecordsCopier.copy(sellerOfRecords);
        }

        @Override
        public final Builder sellerOfRecords(Collection<String> sellerOfRecords) {
            this.sellerOfRecords = SellerOfRecordsCopier.copy(sellerOfRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sellerOfRecords(String ... sellerOfRecords) {
            this.sellerOfRecords(Arrays.asList(sellerOfRecords));
            return this;
        }

        public ProcurementPortalPreferenceSelector build() {
            return new ProcurementPortalPreferenceSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcurementPortalPreferenceSelector> {
        public Builder invoiceUnitArns(Collection<String> var1);

        public Builder invoiceUnitArns(String ... var1);

        public Builder sellerOfRecords(Collection<String> var1);

        public Builder sellerOfRecords(String ... var1);
    }
}

