/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.invoicing.model.BuyerDomain;
import software.amazon.awssdk.services.invoicing.model.Contact;
import software.amazon.awssdk.services.invoicing.model.ContactsCopier;
import software.amazon.awssdk.services.invoicing.model.EinvoiceDeliveryPreference;
import software.amazon.awssdk.services.invoicing.model.ProcurementPortalName;
import software.amazon.awssdk.services.invoicing.model.ProcurementPortalPreferenceSelector;
import software.amazon.awssdk.services.invoicing.model.ProcurementPortalPreferenceStatus;
import software.amazon.awssdk.services.invoicing.model.SupplierDomain;
import software.amazon.awssdk.services.invoicing.model.TestEnvPreference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcurementPortalPreference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcurementPortalPreference> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::awsAccountId)).setter(ProcurementPortalPreference.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcurementPortalPreferenceArn").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::procurementPortalPreferenceArn)).setter(ProcurementPortalPreference.setter(Builder::procurementPortalPreferenceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalPreferenceArn").build()}).build();
    private static final SdkField<String> PROCUREMENT_PORTAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcurementPortalName").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::procurementPortalNameAsString)).setter(ProcurementPortalPreference.setter(Builder::procurementPortalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalName").build()}).build();
    private static final SdkField<String> BUYER_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuyerDomain").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::buyerDomainAsString)).setter(ProcurementPortalPreference.setter(Builder::buyerDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerDomain").build()}).build();
    private static final SdkField<String> BUYER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuyerIdentifier").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::buyerIdentifier)).setter(ProcurementPortalPreference.setter(Builder::buyerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerIdentifier").build()}).build();
    private static final SdkField<String> SUPPLIER_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupplierDomain").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::supplierDomainAsString)).setter(ProcurementPortalPreference.setter(Builder::supplierDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplierDomain").build()}).build();
    private static final SdkField<String> SUPPLIER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupplierIdentifier").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::supplierIdentifier)).setter(ProcurementPortalPreference.setter(Builder::supplierIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplierIdentifier").build()}).build();
    private static final SdkField<ProcurementPortalPreferenceSelector> SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Selector").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::selector)).setter(ProcurementPortalPreference.setter(Builder::selector)).constructor(ProcurementPortalPreferenceSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Selector").build()}).build();
    private static final SdkField<String> PROCUREMENT_PORTAL_SHARED_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcurementPortalSharedSecret").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::procurementPortalSharedSecret)).setter(ProcurementPortalPreference.setter(Builder::procurementPortalSharedSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalSharedSecret").build()}).build();
    private static final SdkField<String> PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcurementPortalInstanceEndpoint").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::procurementPortalInstanceEndpoint)).setter(ProcurementPortalPreference.setter(Builder::procurementPortalInstanceEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalInstanceEndpoint").build()}).build();
    private static final SdkField<String> PURCHASE_ORDER_RETRIEVAL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PurchaseOrderRetrievalEndpoint").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::purchaseOrderRetrievalEndpoint)).setter(ProcurementPortalPreference.setter(Builder::purchaseOrderRetrievalEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderRetrievalEndpoint").build()}).build();
    private static final SdkField<TestEnvPreference> TEST_ENV_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TestEnvPreference").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::testEnvPreference)).setter(ProcurementPortalPreference.setter(Builder::testEnvPreference)).constructor(TestEnvPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestEnvPreference").build()}).build();
    private static final SdkField<Boolean> EINVOICE_DELIVERY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EinvoiceDeliveryEnabled").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::einvoiceDeliveryEnabled)).setter(ProcurementPortalPreference.setter(Builder::einvoiceDeliveryEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryEnabled").build()}).build();
    private static final SdkField<EinvoiceDeliveryPreference> EINVOICE_DELIVERY_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EinvoiceDeliveryPreference").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::einvoiceDeliveryPreference)).setter(ProcurementPortalPreference.setter(Builder::einvoiceDeliveryPreference)).constructor(EinvoiceDeliveryPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryPreference").build()}).build();
    private static final SdkField<Boolean> PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PurchaseOrderRetrievalEnabled").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::purchaseOrderRetrievalEnabled)).setter(ProcurementPortalPreference.setter(Builder::purchaseOrderRetrievalEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderRetrievalEnabled").build()}).build();
    private static final SdkField<List<Contact>> CONTACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Contacts").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::contacts)).setter(ProcurementPortalPreference.setter(Builder::contacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Contact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EINVOICE_DELIVERY_PREFERENCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EinvoiceDeliveryPreferenceStatus").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::einvoiceDeliveryPreferenceStatusAsString)).setter(ProcurementPortalPreference.setter(Builder::einvoiceDeliveryPreferenceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryPreferenceStatus").build()}).build();
    private static final SdkField<String> EINVOICE_DELIVERY_PREFERENCE_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EinvoiceDeliveryPreferenceStatusReason").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::einvoiceDeliveryPreferenceStatusReason)).setter(ProcurementPortalPreference.setter(Builder::einvoiceDeliveryPreferenceStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryPreferenceStatusReason").build()}).build();
    private static final SdkField<String> PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PurchaseOrderRetrievalPreferenceStatus").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::purchaseOrderRetrievalPreferenceStatusAsString)).setter(ProcurementPortalPreference.setter(Builder::purchaseOrderRetrievalPreferenceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderRetrievalPreferenceStatus").build()}).build();
    private static final SdkField<String> PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PurchaseOrderRetrievalPreferenceStatusReason").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::purchaseOrderRetrievalPreferenceStatusReason)).setter(ProcurementPortalPreference.setter(Builder::purchaseOrderRetrievalPreferenceStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderRetrievalPreferenceStatusReason").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Version").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::version)).setter(ProcurementPortalPreference.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::createDate)).setter(ProcurementPortalPreference.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateDate").getter(ProcurementPortalPreference.getter(ProcurementPortalPreference::lastUpdateDate)).setter(ProcurementPortalPreference.setter(Builder::lastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD, PROCUREMENT_PORTAL_NAME_FIELD, BUYER_DOMAIN_FIELD, BUYER_IDENTIFIER_FIELD, SUPPLIER_DOMAIN_FIELD, SUPPLIER_IDENTIFIER_FIELD, SELECTOR_FIELD, PROCUREMENT_PORTAL_SHARED_SECRET_FIELD, PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD, PURCHASE_ORDER_RETRIEVAL_ENDPOINT_FIELD, TEST_ENV_PREFERENCE_FIELD, EINVOICE_DELIVERY_ENABLED_FIELD, EINVOICE_DELIVERY_PREFERENCE_FIELD, PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD, CONTACTS_FIELD, EINVOICE_DELIVERY_PREFERENCE_STATUS_FIELD, EINVOICE_DELIVERY_PREFERENCE_STATUS_REASON_FIELD, PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_FIELD, PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_REASON_FIELD, VERSION_FIELD, CREATE_DATE_FIELD, LAST_UPDATE_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProcurementPortalPreference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String awsAccountId;
    private final String procurementPortalPreferenceArn;
    private final String procurementPortalName;
    private final String buyerDomain;
    private final String buyerIdentifier;
    private final String supplierDomain;
    private final String supplierIdentifier;
    private final ProcurementPortalPreferenceSelector selector;
    private final String procurementPortalSharedSecret;
    private final String procurementPortalInstanceEndpoint;
    private final String purchaseOrderRetrievalEndpoint;
    private final TestEnvPreference testEnvPreference;
    private final Boolean einvoiceDeliveryEnabled;
    private final EinvoiceDeliveryPreference einvoiceDeliveryPreference;
    private final Boolean purchaseOrderRetrievalEnabled;
    private final List<Contact> contacts;
    private final String einvoiceDeliveryPreferenceStatus;
    private final String einvoiceDeliveryPreferenceStatusReason;
    private final String purchaseOrderRetrievalPreferenceStatus;
    private final String purchaseOrderRetrievalPreferenceStatusReason;
    private final Long version;
    private final Instant createDate;
    private final Instant lastUpdateDate;

    private ProcurementPortalPreference(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.procurementPortalPreferenceArn = builder.procurementPortalPreferenceArn;
        this.procurementPortalName = builder.procurementPortalName;
        this.buyerDomain = builder.buyerDomain;
        this.buyerIdentifier = builder.buyerIdentifier;
        this.supplierDomain = builder.supplierDomain;
        this.supplierIdentifier = builder.supplierIdentifier;
        this.selector = builder.selector;
        this.procurementPortalSharedSecret = builder.procurementPortalSharedSecret;
        this.procurementPortalInstanceEndpoint = builder.procurementPortalInstanceEndpoint;
        this.purchaseOrderRetrievalEndpoint = builder.purchaseOrderRetrievalEndpoint;
        this.testEnvPreference = builder.testEnvPreference;
        this.einvoiceDeliveryEnabled = builder.einvoiceDeliveryEnabled;
        this.einvoiceDeliveryPreference = builder.einvoiceDeliveryPreference;
        this.purchaseOrderRetrievalEnabled = builder.purchaseOrderRetrievalEnabled;
        this.contacts = builder.contacts;
        this.einvoiceDeliveryPreferenceStatus = builder.einvoiceDeliveryPreferenceStatus;
        this.einvoiceDeliveryPreferenceStatusReason = builder.einvoiceDeliveryPreferenceStatusReason;
        this.purchaseOrderRetrievalPreferenceStatus = builder.purchaseOrderRetrievalPreferenceStatus;
        this.purchaseOrderRetrievalPreferenceStatusReason = builder.purchaseOrderRetrievalPreferenceStatusReason;
        this.version = builder.version;
        this.createDate = builder.createDate;
        this.lastUpdateDate = builder.lastUpdateDate;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String procurementPortalPreferenceArn() {
        return this.procurementPortalPreferenceArn;
    }

    public final ProcurementPortalName procurementPortalName() {
        return ProcurementPortalName.fromValue(this.procurementPortalName);
    }

    public final String procurementPortalNameAsString() {
        return this.procurementPortalName;
    }

    public final BuyerDomain buyerDomain() {
        return BuyerDomain.fromValue(this.buyerDomain);
    }

    public final String buyerDomainAsString() {
        return this.buyerDomain;
    }

    public final String buyerIdentifier() {
        return this.buyerIdentifier;
    }

    public final SupplierDomain supplierDomain() {
        return SupplierDomain.fromValue(this.supplierDomain);
    }

    public final String supplierDomainAsString() {
        return this.supplierDomain;
    }

    public final String supplierIdentifier() {
        return this.supplierIdentifier;
    }

    public final ProcurementPortalPreferenceSelector selector() {
        return this.selector;
    }

    public final String procurementPortalSharedSecret() {
        return this.procurementPortalSharedSecret;
    }

    public final String procurementPortalInstanceEndpoint() {
        return this.procurementPortalInstanceEndpoint;
    }

    public final String purchaseOrderRetrievalEndpoint() {
        return this.purchaseOrderRetrievalEndpoint;
    }

    public final TestEnvPreference testEnvPreference() {
        return this.testEnvPreference;
    }

    public final Boolean einvoiceDeliveryEnabled() {
        return this.einvoiceDeliveryEnabled;
    }

    public final EinvoiceDeliveryPreference einvoiceDeliveryPreference() {
        return this.einvoiceDeliveryPreference;
    }

    public final Boolean purchaseOrderRetrievalEnabled() {
        return this.purchaseOrderRetrievalEnabled;
    }

    public final boolean hasContacts() {
        return this.contacts != null && !(this.contacts instanceof SdkAutoConstructList);
    }

    public final List<Contact> contacts() {
        return this.contacts;
    }

    public final ProcurementPortalPreferenceStatus einvoiceDeliveryPreferenceStatus() {
        return ProcurementPortalPreferenceStatus.fromValue(this.einvoiceDeliveryPreferenceStatus);
    }

    public final String einvoiceDeliveryPreferenceStatusAsString() {
        return this.einvoiceDeliveryPreferenceStatus;
    }

    public final String einvoiceDeliveryPreferenceStatusReason() {
        return this.einvoiceDeliveryPreferenceStatusReason;
    }

    public final ProcurementPortalPreferenceStatus purchaseOrderRetrievalPreferenceStatus() {
        return ProcurementPortalPreferenceStatus.fromValue(this.purchaseOrderRetrievalPreferenceStatus);
    }

    public final String purchaseOrderRetrievalPreferenceStatusAsString() {
        return this.purchaseOrderRetrievalPreferenceStatus;
    }

    public final String purchaseOrderRetrievalPreferenceStatusReason() {
        return this.purchaseOrderRetrievalPreferenceStatusReason;
    }

    public final Long version() {
        return this.version;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final Instant lastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.procurementPortalPreferenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.procurementPortalNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.buyerDomainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.buyerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplierDomainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplierIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.selector());
        hashCode = 31 * hashCode + Objects.hashCode(this.procurementPortalSharedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.procurementPortalInstanceEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseOrderRetrievalEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.testEnvPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.einvoiceDeliveryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.einvoiceDeliveryPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseOrderRetrievalEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContacts() ? this.contacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.einvoiceDeliveryPreferenceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.einvoiceDeliveryPreferenceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseOrderRetrievalPreferenceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseOrderRetrievalPreferenceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcurementPortalPreference)) {
            return false;
        }
        ProcurementPortalPreference other = (ProcurementPortalPreference)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.procurementPortalPreferenceArn(), other.procurementPortalPreferenceArn()) && Objects.equals(this.procurementPortalNameAsString(), other.procurementPortalNameAsString()) && Objects.equals(this.buyerDomainAsString(), other.buyerDomainAsString()) && Objects.equals(this.buyerIdentifier(), other.buyerIdentifier()) && Objects.equals(this.supplierDomainAsString(), other.supplierDomainAsString()) && Objects.equals(this.supplierIdentifier(), other.supplierIdentifier()) && Objects.equals(this.selector(), other.selector()) && Objects.equals(this.procurementPortalSharedSecret(), other.procurementPortalSharedSecret()) && Objects.equals(this.procurementPortalInstanceEndpoint(), other.procurementPortalInstanceEndpoint()) && Objects.equals(this.purchaseOrderRetrievalEndpoint(), other.purchaseOrderRetrievalEndpoint()) && Objects.equals(this.testEnvPreference(), other.testEnvPreference()) && Objects.equals(this.einvoiceDeliveryEnabled(), other.einvoiceDeliveryEnabled()) && Objects.equals(this.einvoiceDeliveryPreference(), other.einvoiceDeliveryPreference()) && Objects.equals(this.purchaseOrderRetrievalEnabled(), other.purchaseOrderRetrievalEnabled()) && this.hasContacts() == other.hasContacts() && Objects.equals(this.contacts(), other.contacts()) && Objects.equals(this.einvoiceDeliveryPreferenceStatusAsString(), other.einvoiceDeliveryPreferenceStatusAsString()) && Objects.equals(this.einvoiceDeliveryPreferenceStatusReason(), other.einvoiceDeliveryPreferenceStatusReason()) && Objects.equals(this.purchaseOrderRetrievalPreferenceStatusAsString(), other.purchaseOrderRetrievalPreferenceStatusAsString()) && Objects.equals(this.purchaseOrderRetrievalPreferenceStatusReason(), other.purchaseOrderRetrievalPreferenceStatusReason()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.lastUpdateDate(), other.lastUpdateDate());
    }

    public final String toString() {
        return ToString.builder((String)"ProcurementPortalPreference").add("AwsAccountId", (Object)this.awsAccountId()).add("ProcurementPortalPreferenceArn", (Object)this.procurementPortalPreferenceArn()).add("ProcurementPortalName", (Object)this.procurementPortalNameAsString()).add("BuyerDomain", (Object)this.buyerDomainAsString()).add("BuyerIdentifier", (Object)this.buyerIdentifier()).add("SupplierDomain", (Object)this.supplierDomainAsString()).add("SupplierIdentifier", (Object)this.supplierIdentifier()).add("Selector", (Object)this.selector()).add("ProcurementPortalSharedSecret", (Object)this.procurementPortalSharedSecret()).add("ProcurementPortalInstanceEndpoint", (Object)this.procurementPortalInstanceEndpoint()).add("PurchaseOrderRetrievalEndpoint", (Object)this.purchaseOrderRetrievalEndpoint()).add("TestEnvPreference", (Object)this.testEnvPreference()).add("EinvoiceDeliveryEnabled", (Object)this.einvoiceDeliveryEnabled()).add("EinvoiceDeliveryPreference", (Object)this.einvoiceDeliveryPreference()).add("PurchaseOrderRetrievalEnabled", (Object)this.purchaseOrderRetrievalEnabled()).add("Contacts", (Object)(this.contacts() == null ? null : "*** Sensitive Data Redacted ***")).add("EinvoiceDeliveryPreferenceStatus", (Object)this.einvoiceDeliveryPreferenceStatusAsString()).add("EinvoiceDeliveryPreferenceStatusReason", (Object)this.einvoiceDeliveryPreferenceStatusReason()).add("PurchaseOrderRetrievalPreferenceStatus", (Object)this.purchaseOrderRetrievalPreferenceStatusAsString()).add("PurchaseOrderRetrievalPreferenceStatusReason", (Object)this.purchaseOrderRetrievalPreferenceStatusReason()).add("Version", (Object)this.version()).add("CreateDate", (Object)this.createDate()).add("LastUpdateDate", (Object)this.lastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "ProcurementPortalPreferenceArn": {
                return Optional.ofNullable(clazz.cast(this.procurementPortalPreferenceArn()));
            }
            case "ProcurementPortalName": {
                return Optional.ofNullable(clazz.cast(this.procurementPortalNameAsString()));
            }
            case "BuyerDomain": {
                return Optional.ofNullable(clazz.cast(this.buyerDomainAsString()));
            }
            case "BuyerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.buyerIdentifier()));
            }
            case "SupplierDomain": {
                return Optional.ofNullable(clazz.cast(this.supplierDomainAsString()));
            }
            case "SupplierIdentifier": {
                return Optional.ofNullable(clazz.cast(this.supplierIdentifier()));
            }
            case "Selector": {
                return Optional.ofNullable(clazz.cast(this.selector()));
            }
            case "ProcurementPortalSharedSecret": {
                return Optional.ofNullable(clazz.cast(this.procurementPortalSharedSecret()));
            }
            case "ProcurementPortalInstanceEndpoint": {
                return Optional.ofNullable(clazz.cast(this.procurementPortalInstanceEndpoint()));
            }
            case "PurchaseOrderRetrievalEndpoint": {
                return Optional.ofNullable(clazz.cast(this.purchaseOrderRetrievalEndpoint()));
            }
            case "TestEnvPreference": {
                return Optional.ofNullable(clazz.cast(this.testEnvPreference()));
            }
            case "EinvoiceDeliveryEnabled": {
                return Optional.ofNullable(clazz.cast(this.einvoiceDeliveryEnabled()));
            }
            case "EinvoiceDeliveryPreference": {
                return Optional.ofNullable(clazz.cast(this.einvoiceDeliveryPreference()));
            }
            case "PurchaseOrderRetrievalEnabled": {
                return Optional.ofNullable(clazz.cast(this.purchaseOrderRetrievalEnabled()));
            }
            case "Contacts": {
                return Optional.ofNullable(clazz.cast(this.contacts()));
            }
            case "EinvoiceDeliveryPreferenceStatus": {
                return Optional.ofNullable(clazz.cast(this.einvoiceDeliveryPreferenceStatusAsString()));
            }
            case "EinvoiceDeliveryPreferenceStatusReason": {
                return Optional.ofNullable(clazz.cast(this.einvoiceDeliveryPreferenceStatusReason()));
            }
            case "PurchaseOrderRetrievalPreferenceStatus": {
                return Optional.ofNullable(clazz.cast(this.purchaseOrderRetrievalPreferenceStatusAsString()));
            }
            case "PurchaseOrderRetrievalPreferenceStatusReason": {
                return Optional.ofNullable(clazz.cast(this.purchaseOrderRetrievalPreferenceStatusReason()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "LastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("ProcurementPortalPreferenceArn", PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD);
        map.put("ProcurementPortalName", PROCUREMENT_PORTAL_NAME_FIELD);
        map.put("BuyerDomain", BUYER_DOMAIN_FIELD);
        map.put("BuyerIdentifier", BUYER_IDENTIFIER_FIELD);
        map.put("SupplierDomain", SUPPLIER_DOMAIN_FIELD);
        map.put("SupplierIdentifier", SUPPLIER_IDENTIFIER_FIELD);
        map.put("Selector", SELECTOR_FIELD);
        map.put("ProcurementPortalSharedSecret", PROCUREMENT_PORTAL_SHARED_SECRET_FIELD);
        map.put("ProcurementPortalInstanceEndpoint", PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD);
        map.put("PurchaseOrderRetrievalEndpoint", PURCHASE_ORDER_RETRIEVAL_ENDPOINT_FIELD);
        map.put("TestEnvPreference", TEST_ENV_PREFERENCE_FIELD);
        map.put("EinvoiceDeliveryEnabled", EINVOICE_DELIVERY_ENABLED_FIELD);
        map.put("EinvoiceDeliveryPreference", EINVOICE_DELIVERY_PREFERENCE_FIELD);
        map.put("PurchaseOrderRetrievalEnabled", PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD);
        map.put("Contacts", CONTACTS_FIELD);
        map.put("EinvoiceDeliveryPreferenceStatus", EINVOICE_DELIVERY_PREFERENCE_STATUS_FIELD);
        map.put("EinvoiceDeliveryPreferenceStatusReason", EINVOICE_DELIVERY_PREFERENCE_STATUS_REASON_FIELD);
        map.put("PurchaseOrderRetrievalPreferenceStatus", PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_FIELD);
        map.put("PurchaseOrderRetrievalPreferenceStatusReason", PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_REASON_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("LastUpdateDate", LAST_UPDATE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProcurementPortalPreference, T> g) {
        return obj -> g.apply((ProcurementPortalPreference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String procurementPortalPreferenceArn;
        private String procurementPortalName;
        private String buyerDomain;
        private String buyerIdentifier;
        private String supplierDomain;
        private String supplierIdentifier;
        private ProcurementPortalPreferenceSelector selector;
        private String procurementPortalSharedSecret;
        private String procurementPortalInstanceEndpoint;
        private String purchaseOrderRetrievalEndpoint;
        private TestEnvPreference testEnvPreference;
        private Boolean einvoiceDeliveryEnabled;
        private EinvoiceDeliveryPreference einvoiceDeliveryPreference;
        private Boolean purchaseOrderRetrievalEnabled;
        private List<Contact> contacts = DefaultSdkAutoConstructList.getInstance();
        private String einvoiceDeliveryPreferenceStatus;
        private String einvoiceDeliveryPreferenceStatusReason;
        private String purchaseOrderRetrievalPreferenceStatus;
        private String purchaseOrderRetrievalPreferenceStatusReason;
        private Long version;
        private Instant createDate;
        private Instant lastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcurementPortalPreference model) {
            this.awsAccountId(model.awsAccountId);
            this.procurementPortalPreferenceArn(model.procurementPortalPreferenceArn);
            this.procurementPortalName(model.procurementPortalName);
            this.buyerDomain(model.buyerDomain);
            this.buyerIdentifier(model.buyerIdentifier);
            this.supplierDomain(model.supplierDomain);
            this.supplierIdentifier(model.supplierIdentifier);
            this.selector(model.selector);
            this.procurementPortalSharedSecret(model.procurementPortalSharedSecret);
            this.procurementPortalInstanceEndpoint(model.procurementPortalInstanceEndpoint);
            this.purchaseOrderRetrievalEndpoint(model.purchaseOrderRetrievalEndpoint);
            this.testEnvPreference(model.testEnvPreference);
            this.einvoiceDeliveryEnabled(model.einvoiceDeliveryEnabled);
            this.einvoiceDeliveryPreference(model.einvoiceDeliveryPreference);
            this.purchaseOrderRetrievalEnabled(model.purchaseOrderRetrievalEnabled);
            this.contacts(model.contacts);
            this.einvoiceDeliveryPreferenceStatus(model.einvoiceDeliveryPreferenceStatus);
            this.einvoiceDeliveryPreferenceStatusReason(model.einvoiceDeliveryPreferenceStatusReason);
            this.purchaseOrderRetrievalPreferenceStatus(model.purchaseOrderRetrievalPreferenceStatus);
            this.purchaseOrderRetrievalPreferenceStatusReason(model.purchaseOrderRetrievalPreferenceStatusReason);
            this.version(model.version);
            this.createDate(model.createDate);
            this.lastUpdateDate(model.lastUpdateDate);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getProcurementPortalPreferenceArn() {
            return this.procurementPortalPreferenceArn;
        }

        public final void setProcurementPortalPreferenceArn(String procurementPortalPreferenceArn) {
            this.procurementPortalPreferenceArn = procurementPortalPreferenceArn;
        }

        @Override
        public final Builder procurementPortalPreferenceArn(String procurementPortalPreferenceArn) {
            this.procurementPortalPreferenceArn = procurementPortalPreferenceArn;
            return this;
        }

        public final String getProcurementPortalName() {
            return this.procurementPortalName;
        }

        public final void setProcurementPortalName(String procurementPortalName) {
            this.procurementPortalName = procurementPortalName;
        }

        @Override
        public final Builder procurementPortalName(String procurementPortalName) {
            this.procurementPortalName = procurementPortalName;
            return this;
        }

        @Override
        public final Builder procurementPortalName(ProcurementPortalName procurementPortalName) {
            this.procurementPortalName(procurementPortalName == null ? null : procurementPortalName.toString());
            return this;
        }

        public final String getBuyerDomain() {
            return this.buyerDomain;
        }

        public final void setBuyerDomain(String buyerDomain) {
            this.buyerDomain = buyerDomain;
        }

        @Override
        public final Builder buyerDomain(String buyerDomain) {
            this.buyerDomain = buyerDomain;
            return this;
        }

        @Override
        public final Builder buyerDomain(BuyerDomain buyerDomain) {
            this.buyerDomain(buyerDomain == null ? null : buyerDomain.toString());
            return this;
        }

        public final String getBuyerIdentifier() {
            return this.buyerIdentifier;
        }

        public final void setBuyerIdentifier(String buyerIdentifier) {
            this.buyerIdentifier = buyerIdentifier;
        }

        @Override
        public final Builder buyerIdentifier(String buyerIdentifier) {
            this.buyerIdentifier = buyerIdentifier;
            return this;
        }

        public final String getSupplierDomain() {
            return this.supplierDomain;
        }

        public final void setSupplierDomain(String supplierDomain) {
            this.supplierDomain = supplierDomain;
        }

        @Override
        public final Builder supplierDomain(String supplierDomain) {
            this.supplierDomain = supplierDomain;
            return this;
        }

        @Override
        public final Builder supplierDomain(SupplierDomain supplierDomain) {
            this.supplierDomain(supplierDomain == null ? null : supplierDomain.toString());
            return this;
        }

        public final String getSupplierIdentifier() {
            return this.supplierIdentifier;
        }

        public final void setSupplierIdentifier(String supplierIdentifier) {
            this.supplierIdentifier = supplierIdentifier;
        }

        @Override
        public final Builder supplierIdentifier(String supplierIdentifier) {
            this.supplierIdentifier = supplierIdentifier;
            return this;
        }

        public final ProcurementPortalPreferenceSelector.Builder getSelector() {
            return this.selector != null ? this.selector.toBuilder() : null;
        }

        public final void setSelector(ProcurementPortalPreferenceSelector.BuilderImpl selector) {
            this.selector = selector != null ? selector.build() : null;
        }

        @Override
        public final Builder selector(ProcurementPortalPreferenceSelector selector) {
            this.selector = selector;
            return this;
        }

        public final String getProcurementPortalSharedSecret() {
            return this.procurementPortalSharedSecret;
        }

        public final void setProcurementPortalSharedSecret(String procurementPortalSharedSecret) {
            this.procurementPortalSharedSecret = procurementPortalSharedSecret;
        }

        @Override
        public final Builder procurementPortalSharedSecret(String procurementPortalSharedSecret) {
            this.procurementPortalSharedSecret = procurementPortalSharedSecret;
            return this;
        }

        public final String getProcurementPortalInstanceEndpoint() {
            return this.procurementPortalInstanceEndpoint;
        }

        public final void setProcurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint) {
            this.procurementPortalInstanceEndpoint = procurementPortalInstanceEndpoint;
        }

        @Override
        public final Builder procurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint) {
            this.procurementPortalInstanceEndpoint = procurementPortalInstanceEndpoint;
            return this;
        }

        public final String getPurchaseOrderRetrievalEndpoint() {
            return this.purchaseOrderRetrievalEndpoint;
        }

        public final void setPurchaseOrderRetrievalEndpoint(String purchaseOrderRetrievalEndpoint) {
            this.purchaseOrderRetrievalEndpoint = purchaseOrderRetrievalEndpoint;
        }

        @Override
        public final Builder purchaseOrderRetrievalEndpoint(String purchaseOrderRetrievalEndpoint) {
            this.purchaseOrderRetrievalEndpoint = purchaseOrderRetrievalEndpoint;
            return this;
        }

        public final TestEnvPreference.Builder getTestEnvPreference() {
            return this.testEnvPreference != null ? this.testEnvPreference.toBuilder() : null;
        }

        public final void setTestEnvPreference(TestEnvPreference.BuilderImpl testEnvPreference) {
            this.testEnvPreference = testEnvPreference != null ? testEnvPreference.build() : null;
        }

        @Override
        public final Builder testEnvPreference(TestEnvPreference testEnvPreference) {
            this.testEnvPreference = testEnvPreference;
            return this;
        }

        public final Boolean getEinvoiceDeliveryEnabled() {
            return this.einvoiceDeliveryEnabled;
        }

        public final void setEinvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled) {
            this.einvoiceDeliveryEnabled = einvoiceDeliveryEnabled;
        }

        @Override
        public final Builder einvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled) {
            this.einvoiceDeliveryEnabled = einvoiceDeliveryEnabled;
            return this;
        }

        public final EinvoiceDeliveryPreference.Builder getEinvoiceDeliveryPreference() {
            return this.einvoiceDeliveryPreference != null ? this.einvoiceDeliveryPreference.toBuilder() : null;
        }

        public final void setEinvoiceDeliveryPreference(EinvoiceDeliveryPreference.BuilderImpl einvoiceDeliveryPreference) {
            this.einvoiceDeliveryPreference = einvoiceDeliveryPreference != null ? einvoiceDeliveryPreference.build() : null;
        }

        @Override
        public final Builder einvoiceDeliveryPreference(EinvoiceDeliveryPreference einvoiceDeliveryPreference) {
            this.einvoiceDeliveryPreference = einvoiceDeliveryPreference;
            return this;
        }

        public final Boolean getPurchaseOrderRetrievalEnabled() {
            return this.purchaseOrderRetrievalEnabled;
        }

        public final void setPurchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled) {
            this.purchaseOrderRetrievalEnabled = purchaseOrderRetrievalEnabled;
        }

        @Override
        public final Builder purchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled) {
            this.purchaseOrderRetrievalEnabled = purchaseOrderRetrievalEnabled;
            return this;
        }

        public final List<Contact.Builder> getContacts() {
            List<Contact.Builder> result = ContactsCopier.copyToBuilder(this.contacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContacts(Collection<Contact.BuilderImpl> contacts) {
            this.contacts = ContactsCopier.copyFromBuilder(contacts);
        }

        @Override
        public final Builder contacts(Collection<Contact> contacts) {
            this.contacts = ContactsCopier.copy(contacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Contact ... contacts) {
            this.contacts(Arrays.asList(contacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Consumer<Contact.Builder> ... contacts) {
            this.contacts(Stream.of(contacts).map(c -> (Contact)((Contact.Builder)Contact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEinvoiceDeliveryPreferenceStatus() {
            return this.einvoiceDeliveryPreferenceStatus;
        }

        public final void setEinvoiceDeliveryPreferenceStatus(String einvoiceDeliveryPreferenceStatus) {
            this.einvoiceDeliveryPreferenceStatus = einvoiceDeliveryPreferenceStatus;
        }

        @Override
        public final Builder einvoiceDeliveryPreferenceStatus(String einvoiceDeliveryPreferenceStatus) {
            this.einvoiceDeliveryPreferenceStatus = einvoiceDeliveryPreferenceStatus;
            return this;
        }

        @Override
        public final Builder einvoiceDeliveryPreferenceStatus(ProcurementPortalPreferenceStatus einvoiceDeliveryPreferenceStatus) {
            this.einvoiceDeliveryPreferenceStatus(einvoiceDeliveryPreferenceStatus == null ? null : einvoiceDeliveryPreferenceStatus.toString());
            return this;
        }

        public final String getEinvoiceDeliveryPreferenceStatusReason() {
            return this.einvoiceDeliveryPreferenceStatusReason;
        }

        public final void setEinvoiceDeliveryPreferenceStatusReason(String einvoiceDeliveryPreferenceStatusReason) {
            this.einvoiceDeliveryPreferenceStatusReason = einvoiceDeliveryPreferenceStatusReason;
        }

        @Override
        public final Builder einvoiceDeliveryPreferenceStatusReason(String einvoiceDeliveryPreferenceStatusReason) {
            this.einvoiceDeliveryPreferenceStatusReason = einvoiceDeliveryPreferenceStatusReason;
            return this;
        }

        public final String getPurchaseOrderRetrievalPreferenceStatus() {
            return this.purchaseOrderRetrievalPreferenceStatus;
        }

        public final void setPurchaseOrderRetrievalPreferenceStatus(String purchaseOrderRetrievalPreferenceStatus) {
            this.purchaseOrderRetrievalPreferenceStatus = purchaseOrderRetrievalPreferenceStatus;
        }

        @Override
        public final Builder purchaseOrderRetrievalPreferenceStatus(String purchaseOrderRetrievalPreferenceStatus) {
            this.purchaseOrderRetrievalPreferenceStatus = purchaseOrderRetrievalPreferenceStatus;
            return this;
        }

        @Override
        public final Builder purchaseOrderRetrievalPreferenceStatus(ProcurementPortalPreferenceStatus purchaseOrderRetrievalPreferenceStatus) {
            this.purchaseOrderRetrievalPreferenceStatus(purchaseOrderRetrievalPreferenceStatus == null ? null : purchaseOrderRetrievalPreferenceStatus.toString());
            return this;
        }

        public final String getPurchaseOrderRetrievalPreferenceStatusReason() {
            return this.purchaseOrderRetrievalPreferenceStatusReason;
        }

        public final void setPurchaseOrderRetrievalPreferenceStatusReason(String purchaseOrderRetrievalPreferenceStatusReason) {
            this.purchaseOrderRetrievalPreferenceStatusReason = purchaseOrderRetrievalPreferenceStatusReason;
        }

        @Override
        public final Builder purchaseOrderRetrievalPreferenceStatusReason(String purchaseOrderRetrievalPreferenceStatusReason) {
            this.purchaseOrderRetrievalPreferenceStatusReason = purchaseOrderRetrievalPreferenceStatusReason;
            return this;
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return this.lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public ProcurementPortalPreference build() {
            return new ProcurementPortalPreference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcurementPortalPreference> {
        public Builder awsAccountId(String var1);

        public Builder procurementPortalPreferenceArn(String var1);

        public Builder procurementPortalName(String var1);

        public Builder procurementPortalName(ProcurementPortalName var1);

        public Builder buyerDomain(String var1);

        public Builder buyerDomain(BuyerDomain var1);

        public Builder buyerIdentifier(String var1);

        public Builder supplierDomain(String var1);

        public Builder supplierDomain(SupplierDomain var1);

        public Builder supplierIdentifier(String var1);

        public Builder selector(ProcurementPortalPreferenceSelector var1);

        default public Builder selector(Consumer<ProcurementPortalPreferenceSelector.Builder> selector) {
            return this.selector((ProcurementPortalPreferenceSelector)((ProcurementPortalPreferenceSelector.Builder)ProcurementPortalPreferenceSelector.builder().applyMutation(selector)).build());
        }

        public Builder procurementPortalSharedSecret(String var1);

        public Builder procurementPortalInstanceEndpoint(String var1);

        public Builder purchaseOrderRetrievalEndpoint(String var1);

        public Builder testEnvPreference(TestEnvPreference var1);

        default public Builder testEnvPreference(Consumer<TestEnvPreference.Builder> testEnvPreference) {
            return this.testEnvPreference((TestEnvPreference)((TestEnvPreference.Builder)TestEnvPreference.builder().applyMutation(testEnvPreference)).build());
        }

        public Builder einvoiceDeliveryEnabled(Boolean var1);

        public Builder einvoiceDeliveryPreference(EinvoiceDeliveryPreference var1);

        default public Builder einvoiceDeliveryPreference(Consumer<EinvoiceDeliveryPreference.Builder> einvoiceDeliveryPreference) {
            return this.einvoiceDeliveryPreference((EinvoiceDeliveryPreference)((EinvoiceDeliveryPreference.Builder)EinvoiceDeliveryPreference.builder().applyMutation(einvoiceDeliveryPreference)).build());
        }

        public Builder purchaseOrderRetrievalEnabled(Boolean var1);

        public Builder contacts(Collection<Contact> var1);

        public Builder contacts(Contact ... var1);

        public Builder contacts(Consumer<Contact.Builder> ... var1);

        public Builder einvoiceDeliveryPreferenceStatus(String var1);

        public Builder einvoiceDeliveryPreferenceStatus(ProcurementPortalPreferenceStatus var1);

        public Builder einvoiceDeliveryPreferenceStatusReason(String var1);

        public Builder purchaseOrderRetrievalPreferenceStatus(String var1);

        public Builder purchaseOrderRetrievalPreferenceStatus(ProcurementPortalPreferenceStatus var1);

        public Builder purchaseOrderRetrievalPreferenceStatusReason(String var1);

        public Builder version(Long var1);

        public Builder createDate(Instant var1);

        public Builder lastUpdateDate(Instant var1);
    }
}

