/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.invoicing.model.SupplementalDocument;
import software.amazon.awssdk.services.invoicing.model.SupplementalDocumentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvoicePDF
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvoicePDF> {
    private static final SdkField<String> INVOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvoiceId").getter(InvoicePDF.getter(InvoicePDF::invoiceId)).setter(InvoicePDF.setter(Builder::invoiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceId").build()}).build();
    private static final SdkField<String> DOCUMENT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentUrl").getter(InvoicePDF.getter(InvoicePDF::documentUrl)).setter(InvoicePDF.setter(Builder::documentUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentUrl").build()}).build();
    private static final SdkField<Instant> DOCUMENT_URL_EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DocumentUrlExpirationDate").getter(InvoicePDF.getter(InvoicePDF::documentUrlExpirationDate)).setter(InvoicePDF.setter(Builder::documentUrlExpirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentUrlExpirationDate").build()}).build();
    private static final SdkField<List<SupplementalDocument>> SUPPLEMENTAL_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupplementalDocuments").getter(InvoicePDF.getter(InvoicePDF::supplementalDocuments)).setter(InvoicePDF.setter(Builder::supplementalDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplementalDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SupplementalDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOICE_ID_FIELD, DOCUMENT_URL_FIELD, DOCUMENT_URL_EXPIRATION_DATE_FIELD, SUPPLEMENTAL_DOCUMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvoicePDF.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String invoiceId;
    private final String documentUrl;
    private final Instant documentUrlExpirationDate;
    private final List<SupplementalDocument> supplementalDocuments;

    private InvoicePDF(BuilderImpl builder) {
        this.invoiceId = builder.invoiceId;
        this.documentUrl = builder.documentUrl;
        this.documentUrlExpirationDate = builder.documentUrlExpirationDate;
        this.supplementalDocuments = builder.supplementalDocuments;
    }

    public final String invoiceId() {
        return this.invoiceId;
    }

    public final String documentUrl() {
        return this.documentUrl;
    }

    public final Instant documentUrlExpirationDate() {
        return this.documentUrlExpirationDate;
    }

    public final boolean hasSupplementalDocuments() {
        return this.supplementalDocuments != null && !(this.supplementalDocuments instanceof SdkAutoConstructList);
    }

    public final List<SupplementalDocument> supplementalDocuments() {
        return this.supplementalDocuments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invoiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentUrlExpirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupplementalDocuments() ? this.supplementalDocuments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvoicePDF)) {
            return false;
        }
        InvoicePDF other = (InvoicePDF)obj;
        return Objects.equals(this.invoiceId(), other.invoiceId()) && Objects.equals(this.documentUrl(), other.documentUrl()) && Objects.equals(this.documentUrlExpirationDate(), other.documentUrlExpirationDate()) && this.hasSupplementalDocuments() == other.hasSupplementalDocuments() && Objects.equals(this.supplementalDocuments(), other.supplementalDocuments());
    }

    public final String toString() {
        return ToString.builder((String)"InvoicePDF").add("InvoiceId", (Object)this.invoiceId()).add("DocumentUrl", (Object)this.documentUrl()).add("DocumentUrlExpirationDate", (Object)this.documentUrlExpirationDate()).add("SupplementalDocuments", this.hasSupplementalDocuments() ? this.supplementalDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvoiceId": {
                return Optional.ofNullable(clazz.cast(this.invoiceId()));
            }
            case "DocumentUrl": {
                return Optional.ofNullable(clazz.cast(this.documentUrl()));
            }
            case "DocumentUrlExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.documentUrlExpirationDate()));
            }
            case "SupplementalDocuments": {
                return Optional.ofNullable(clazz.cast(this.supplementalDocuments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InvoiceId", INVOICE_ID_FIELD);
        map.put("DocumentUrl", DOCUMENT_URL_FIELD);
        map.put("DocumentUrlExpirationDate", DOCUMENT_URL_EXPIRATION_DATE_FIELD);
        map.put("SupplementalDocuments", SUPPLEMENTAL_DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvoicePDF, T> g) {
        return obj -> g.apply((InvoicePDF)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String invoiceId;
        private String documentUrl;
        private Instant documentUrlExpirationDate;
        private List<SupplementalDocument> supplementalDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvoicePDF model) {
            this.invoiceId(model.invoiceId);
            this.documentUrl(model.documentUrl);
            this.documentUrlExpirationDate(model.documentUrlExpirationDate);
            this.supplementalDocuments(model.supplementalDocuments);
        }

        public final String getInvoiceId() {
            return this.invoiceId;
        }

        public final void setInvoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        @Override
        public final Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public final String getDocumentUrl() {
            return this.documentUrl;
        }

        public final void setDocumentUrl(String documentUrl) {
            this.documentUrl = documentUrl;
        }

        @Override
        public final Builder documentUrl(String documentUrl) {
            this.documentUrl = documentUrl;
            return this;
        }

        public final Instant getDocumentUrlExpirationDate() {
            return this.documentUrlExpirationDate;
        }

        public final void setDocumentUrlExpirationDate(Instant documentUrlExpirationDate) {
            this.documentUrlExpirationDate = documentUrlExpirationDate;
        }

        @Override
        public final Builder documentUrlExpirationDate(Instant documentUrlExpirationDate) {
            this.documentUrlExpirationDate = documentUrlExpirationDate;
            return this;
        }

        public final List<SupplementalDocument.Builder> getSupplementalDocuments() {
            List<SupplementalDocument.Builder> result = SupplementalDocumentsCopier.copyToBuilder(this.supplementalDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupplementalDocuments(Collection<SupplementalDocument.BuilderImpl> supplementalDocuments) {
            this.supplementalDocuments = SupplementalDocumentsCopier.copyFromBuilder(supplementalDocuments);
        }

        @Override
        public final Builder supplementalDocuments(Collection<SupplementalDocument> supplementalDocuments) {
            this.supplementalDocuments = SupplementalDocumentsCopier.copy(supplementalDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supplementalDocuments(SupplementalDocument ... supplementalDocuments) {
            this.supplementalDocuments(Arrays.asList(supplementalDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supplementalDocuments(Consumer<SupplementalDocument.Builder> ... supplementalDocuments) {
            this.supplementalDocuments(Stream.of(supplementalDocuments).map(c -> (SupplementalDocument)((SupplementalDocument.Builder)SupplementalDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InvoicePDF build() {
            return new InvoicePDF(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvoicePDF> {
        public Builder invoiceId(String var1);

        public Builder documentUrl(String var1);

        public Builder documentUrlExpirationDate(Instant var1);

        public Builder supplementalDocuments(Collection<SupplementalDocument> var1);

        public Builder supplementalDocuments(SupplementalDocument ... var1);

        public Builder supplementalDocuments(Consumer<SupplementalDocument.Builder> ... var1);
    }
}

