/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.invoicing.model.ConnectionTestingMethod;
import software.amazon.awssdk.services.invoicing.model.EinvoiceDeliveryAttachmentType;
import software.amazon.awssdk.services.invoicing.model.EinvoiceDeliveryAttachmentTypesCopier;
import software.amazon.awssdk.services.invoicing.model.EinvoiceDeliveryDocumentType;
import software.amazon.awssdk.services.invoicing.model.EinvoiceDeliveryDocumentTypesCopier;
import software.amazon.awssdk.services.invoicing.model.Protocol;
import software.amazon.awssdk.services.invoicing.model.PurchaseOrderDataSource;
import software.amazon.awssdk.services.invoicing.model.PurchaseOrderDataSourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EinvoiceDeliveryPreference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EinvoiceDeliveryPreference> {
    private static final SdkField<List<String>> EINVOICE_DELIVERY_DOCUMENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EinvoiceDeliveryDocumentTypes").getter(EinvoiceDeliveryPreference.getter(EinvoiceDeliveryPreference::einvoiceDeliveryDocumentTypesAsStrings)).setter(EinvoiceDeliveryPreference.setter(Builder::einvoiceDeliveryDocumentTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryDocumentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EINVOICE_DELIVERY_ATTACHMENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EinvoiceDeliveryAttachmentTypes").getter(EinvoiceDeliveryPreference.getter(EinvoiceDeliveryPreference::einvoiceDeliveryAttachmentTypesAsStrings)).setter(EinvoiceDeliveryPreference.setter(Builder::einvoiceDeliveryAttachmentTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryAttachmentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(EinvoiceDeliveryPreference.getter(EinvoiceDeliveryPreference::protocolAsString)).setter(EinvoiceDeliveryPreference.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<List<PurchaseOrderDataSource>> PURCHASE_ORDER_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PurchaseOrderDataSources").getter(EinvoiceDeliveryPreference.getter(EinvoiceDeliveryPreference::purchaseOrderDataSources)).setter(EinvoiceDeliveryPreference.setter(Builder::purchaseOrderDataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderDataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PurchaseOrderDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTION_TESTING_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionTestingMethod").getter(EinvoiceDeliveryPreference.getter(EinvoiceDeliveryPreference::connectionTestingMethodAsString)).setter(EinvoiceDeliveryPreference.setter(Builder::connectionTestingMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTestingMethod").build()}).build();
    private static final SdkField<Instant> EINVOICE_DELIVERY_ACTIVATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EinvoiceDeliveryActivationDate").getter(EinvoiceDeliveryPreference.getter(EinvoiceDeliveryPreference::einvoiceDeliveryActivationDate)).setter(EinvoiceDeliveryPreference.setter(Builder::einvoiceDeliveryActivationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryActivationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EINVOICE_DELIVERY_DOCUMENT_TYPES_FIELD, EINVOICE_DELIVERY_ATTACHMENT_TYPES_FIELD, PROTOCOL_FIELD, PURCHASE_ORDER_DATA_SOURCES_FIELD, CONNECTION_TESTING_METHOD_FIELD, EINVOICE_DELIVERY_ACTIVATION_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EinvoiceDeliveryPreference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> einvoiceDeliveryDocumentTypes;
    private final List<String> einvoiceDeliveryAttachmentTypes;
    private final String protocol;
    private final List<PurchaseOrderDataSource> purchaseOrderDataSources;
    private final String connectionTestingMethod;
    private final Instant einvoiceDeliveryActivationDate;

    private EinvoiceDeliveryPreference(BuilderImpl builder) {
        this.einvoiceDeliveryDocumentTypes = builder.einvoiceDeliveryDocumentTypes;
        this.einvoiceDeliveryAttachmentTypes = builder.einvoiceDeliveryAttachmentTypes;
        this.protocol = builder.protocol;
        this.purchaseOrderDataSources = builder.purchaseOrderDataSources;
        this.connectionTestingMethod = builder.connectionTestingMethod;
        this.einvoiceDeliveryActivationDate = builder.einvoiceDeliveryActivationDate;
    }

    public final List<EinvoiceDeliveryDocumentType> einvoiceDeliveryDocumentTypes() {
        return EinvoiceDeliveryDocumentTypesCopier.copyStringToEnum(this.einvoiceDeliveryDocumentTypes);
    }

    public final boolean hasEinvoiceDeliveryDocumentTypes() {
        return this.einvoiceDeliveryDocumentTypes != null && !(this.einvoiceDeliveryDocumentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> einvoiceDeliveryDocumentTypesAsStrings() {
        return this.einvoiceDeliveryDocumentTypes;
    }

    public final List<EinvoiceDeliveryAttachmentType> einvoiceDeliveryAttachmentTypes() {
        return EinvoiceDeliveryAttachmentTypesCopier.copyStringToEnum(this.einvoiceDeliveryAttachmentTypes);
    }

    public final boolean hasEinvoiceDeliveryAttachmentTypes() {
        return this.einvoiceDeliveryAttachmentTypes != null && !(this.einvoiceDeliveryAttachmentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> einvoiceDeliveryAttachmentTypesAsStrings() {
        return this.einvoiceDeliveryAttachmentTypes;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final boolean hasPurchaseOrderDataSources() {
        return this.purchaseOrderDataSources != null && !(this.purchaseOrderDataSources instanceof SdkAutoConstructList);
    }

    public final List<PurchaseOrderDataSource> purchaseOrderDataSources() {
        return this.purchaseOrderDataSources;
    }

    public final ConnectionTestingMethod connectionTestingMethod() {
        return ConnectionTestingMethod.fromValue(this.connectionTestingMethod);
    }

    public final String connectionTestingMethodAsString() {
        return this.connectionTestingMethod;
    }

    public final Instant einvoiceDeliveryActivationDate() {
        return this.einvoiceDeliveryActivationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEinvoiceDeliveryDocumentTypes() ? this.einvoiceDeliveryDocumentTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEinvoiceDeliveryAttachmentTypes() ? this.einvoiceDeliveryAttachmentTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPurchaseOrderDataSources() ? this.purchaseOrderDataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTestingMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.einvoiceDeliveryActivationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EinvoiceDeliveryPreference)) {
            return false;
        }
        EinvoiceDeliveryPreference other = (EinvoiceDeliveryPreference)obj;
        return this.hasEinvoiceDeliveryDocumentTypes() == other.hasEinvoiceDeliveryDocumentTypes() && Objects.equals(this.einvoiceDeliveryDocumentTypesAsStrings(), other.einvoiceDeliveryDocumentTypesAsStrings()) && this.hasEinvoiceDeliveryAttachmentTypes() == other.hasEinvoiceDeliveryAttachmentTypes() && Objects.equals(this.einvoiceDeliveryAttachmentTypesAsStrings(), other.einvoiceDeliveryAttachmentTypesAsStrings()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && this.hasPurchaseOrderDataSources() == other.hasPurchaseOrderDataSources() && Objects.equals(this.purchaseOrderDataSources(), other.purchaseOrderDataSources()) && Objects.equals(this.connectionTestingMethodAsString(), other.connectionTestingMethodAsString()) && Objects.equals(this.einvoiceDeliveryActivationDate(), other.einvoiceDeliveryActivationDate());
    }

    public final String toString() {
        return ToString.builder((String)"EinvoiceDeliveryPreference").add("EinvoiceDeliveryDocumentTypes", this.hasEinvoiceDeliveryDocumentTypes() ? this.einvoiceDeliveryDocumentTypesAsStrings() : null).add("EinvoiceDeliveryAttachmentTypes", this.hasEinvoiceDeliveryAttachmentTypes() ? this.einvoiceDeliveryAttachmentTypesAsStrings() : null).add("Protocol", (Object)this.protocolAsString()).add("PurchaseOrderDataSources", this.hasPurchaseOrderDataSources() ? this.purchaseOrderDataSources() : null).add("ConnectionTestingMethod", (Object)this.connectionTestingMethodAsString()).add("EinvoiceDeliveryActivationDate", (Object)this.einvoiceDeliveryActivationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EinvoiceDeliveryDocumentTypes": {
                return Optional.ofNullable(clazz.cast(this.einvoiceDeliveryDocumentTypesAsStrings()));
            }
            case "EinvoiceDeliveryAttachmentTypes": {
                return Optional.ofNullable(clazz.cast(this.einvoiceDeliveryAttachmentTypesAsStrings()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "PurchaseOrderDataSources": {
                return Optional.ofNullable(clazz.cast(this.purchaseOrderDataSources()));
            }
            case "ConnectionTestingMethod": {
                return Optional.ofNullable(clazz.cast(this.connectionTestingMethodAsString()));
            }
            case "EinvoiceDeliveryActivationDate": {
                return Optional.ofNullable(clazz.cast(this.einvoiceDeliveryActivationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EinvoiceDeliveryDocumentTypes", EINVOICE_DELIVERY_DOCUMENT_TYPES_FIELD);
        map.put("EinvoiceDeliveryAttachmentTypes", EINVOICE_DELIVERY_ATTACHMENT_TYPES_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("PurchaseOrderDataSources", PURCHASE_ORDER_DATA_SOURCES_FIELD);
        map.put("ConnectionTestingMethod", CONNECTION_TESTING_METHOD_FIELD);
        map.put("EinvoiceDeliveryActivationDate", EINVOICE_DELIVERY_ACTIVATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EinvoiceDeliveryPreference, T> g) {
        return obj -> g.apply((EinvoiceDeliveryPreference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> einvoiceDeliveryDocumentTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> einvoiceDeliveryAttachmentTypes = DefaultSdkAutoConstructList.getInstance();
        private String protocol;
        private List<PurchaseOrderDataSource> purchaseOrderDataSources = DefaultSdkAutoConstructList.getInstance();
        private String connectionTestingMethod;
        private Instant einvoiceDeliveryActivationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(EinvoiceDeliveryPreference model) {
            this.einvoiceDeliveryDocumentTypesWithStrings(model.einvoiceDeliveryDocumentTypes);
            this.einvoiceDeliveryAttachmentTypesWithStrings(model.einvoiceDeliveryAttachmentTypes);
            this.protocol(model.protocol);
            this.purchaseOrderDataSources(model.purchaseOrderDataSources);
            this.connectionTestingMethod(model.connectionTestingMethod);
            this.einvoiceDeliveryActivationDate(model.einvoiceDeliveryActivationDate);
        }

        public final Collection<String> getEinvoiceDeliveryDocumentTypes() {
            if (this.einvoiceDeliveryDocumentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.einvoiceDeliveryDocumentTypes;
        }

        public final void setEinvoiceDeliveryDocumentTypes(Collection<String> einvoiceDeliveryDocumentTypes) {
            this.einvoiceDeliveryDocumentTypes = EinvoiceDeliveryDocumentTypesCopier.copy(einvoiceDeliveryDocumentTypes);
        }

        @Override
        public final Builder einvoiceDeliveryDocumentTypesWithStrings(Collection<String> einvoiceDeliveryDocumentTypes) {
            this.einvoiceDeliveryDocumentTypes = EinvoiceDeliveryDocumentTypesCopier.copy(einvoiceDeliveryDocumentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder einvoiceDeliveryDocumentTypesWithStrings(String ... einvoiceDeliveryDocumentTypes) {
            this.einvoiceDeliveryDocumentTypesWithStrings(Arrays.asList(einvoiceDeliveryDocumentTypes));
            return this;
        }

        @Override
        public final Builder einvoiceDeliveryDocumentTypes(Collection<EinvoiceDeliveryDocumentType> einvoiceDeliveryDocumentTypes) {
            this.einvoiceDeliveryDocumentTypes = EinvoiceDeliveryDocumentTypesCopier.copyEnumToString(einvoiceDeliveryDocumentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder einvoiceDeliveryDocumentTypes(EinvoiceDeliveryDocumentType ... einvoiceDeliveryDocumentTypes) {
            this.einvoiceDeliveryDocumentTypes(Arrays.asList(einvoiceDeliveryDocumentTypes));
            return this;
        }

        public final Collection<String> getEinvoiceDeliveryAttachmentTypes() {
            if (this.einvoiceDeliveryAttachmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.einvoiceDeliveryAttachmentTypes;
        }

        public final void setEinvoiceDeliveryAttachmentTypes(Collection<String> einvoiceDeliveryAttachmentTypes) {
            this.einvoiceDeliveryAttachmentTypes = EinvoiceDeliveryAttachmentTypesCopier.copy(einvoiceDeliveryAttachmentTypes);
        }

        @Override
        public final Builder einvoiceDeliveryAttachmentTypesWithStrings(Collection<String> einvoiceDeliveryAttachmentTypes) {
            this.einvoiceDeliveryAttachmentTypes = EinvoiceDeliveryAttachmentTypesCopier.copy(einvoiceDeliveryAttachmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder einvoiceDeliveryAttachmentTypesWithStrings(String ... einvoiceDeliveryAttachmentTypes) {
            this.einvoiceDeliveryAttachmentTypesWithStrings(Arrays.asList(einvoiceDeliveryAttachmentTypes));
            return this;
        }

        @Override
        public final Builder einvoiceDeliveryAttachmentTypes(Collection<EinvoiceDeliveryAttachmentType> einvoiceDeliveryAttachmentTypes) {
            this.einvoiceDeliveryAttachmentTypes = EinvoiceDeliveryAttachmentTypesCopier.copyEnumToString(einvoiceDeliveryAttachmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder einvoiceDeliveryAttachmentTypes(EinvoiceDeliveryAttachmentType ... einvoiceDeliveryAttachmentTypes) {
            this.einvoiceDeliveryAttachmentTypes(Arrays.asList(einvoiceDeliveryAttachmentTypes));
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final List<PurchaseOrderDataSource.Builder> getPurchaseOrderDataSources() {
            List<PurchaseOrderDataSource.Builder> result = PurchaseOrderDataSourcesCopier.copyToBuilder(this.purchaseOrderDataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPurchaseOrderDataSources(Collection<PurchaseOrderDataSource.BuilderImpl> purchaseOrderDataSources) {
            this.purchaseOrderDataSources = PurchaseOrderDataSourcesCopier.copyFromBuilder(purchaseOrderDataSources);
        }

        @Override
        public final Builder purchaseOrderDataSources(Collection<PurchaseOrderDataSource> purchaseOrderDataSources) {
            this.purchaseOrderDataSources = PurchaseOrderDataSourcesCopier.copy(purchaseOrderDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseOrderDataSources(PurchaseOrderDataSource ... purchaseOrderDataSources) {
            this.purchaseOrderDataSources(Arrays.asList(purchaseOrderDataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseOrderDataSources(Consumer<PurchaseOrderDataSource.Builder> ... purchaseOrderDataSources) {
            this.purchaseOrderDataSources(Stream.of(purchaseOrderDataSources).map(c -> (PurchaseOrderDataSource)((PurchaseOrderDataSource.Builder)PurchaseOrderDataSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConnectionTestingMethod() {
            return this.connectionTestingMethod;
        }

        public final void setConnectionTestingMethod(String connectionTestingMethod) {
            this.connectionTestingMethod = connectionTestingMethod;
        }

        @Override
        public final Builder connectionTestingMethod(String connectionTestingMethod) {
            this.connectionTestingMethod = connectionTestingMethod;
            return this;
        }

        @Override
        public final Builder connectionTestingMethod(ConnectionTestingMethod connectionTestingMethod) {
            this.connectionTestingMethod(connectionTestingMethod == null ? null : connectionTestingMethod.toString());
            return this;
        }

        public final Instant getEinvoiceDeliveryActivationDate() {
            return this.einvoiceDeliveryActivationDate;
        }

        public final void setEinvoiceDeliveryActivationDate(Instant einvoiceDeliveryActivationDate) {
            this.einvoiceDeliveryActivationDate = einvoiceDeliveryActivationDate;
        }

        @Override
        public final Builder einvoiceDeliveryActivationDate(Instant einvoiceDeliveryActivationDate) {
            this.einvoiceDeliveryActivationDate = einvoiceDeliveryActivationDate;
            return this;
        }

        public EinvoiceDeliveryPreference build() {
            return new EinvoiceDeliveryPreference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EinvoiceDeliveryPreference> {
        public Builder einvoiceDeliveryDocumentTypesWithStrings(Collection<String> var1);

        public Builder einvoiceDeliveryDocumentTypesWithStrings(String ... var1);

        public Builder einvoiceDeliveryDocumentTypes(Collection<EinvoiceDeliveryDocumentType> var1);

        public Builder einvoiceDeliveryDocumentTypes(EinvoiceDeliveryDocumentType ... var1);

        public Builder einvoiceDeliveryAttachmentTypesWithStrings(Collection<String> var1);

        public Builder einvoiceDeliveryAttachmentTypesWithStrings(String ... var1);

        public Builder einvoiceDeliveryAttachmentTypes(Collection<EinvoiceDeliveryAttachmentType> var1);

        public Builder einvoiceDeliveryAttachmentTypes(EinvoiceDeliveryAttachmentType ... var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder purchaseOrderDataSources(Collection<PurchaseOrderDataSource> var1);

        public Builder purchaseOrderDataSources(PurchaseOrderDataSource ... var1);

        public Builder purchaseOrderDataSources(Consumer<PurchaseOrderDataSource.Builder> ... var1);

        public Builder connectionTestingMethod(String var1);

        public Builder connectionTestingMethod(ConnectionTestingMethod var1);

        public Builder einvoiceDeliveryActivationDate(Instant var1);
    }
}

