/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * <b>Amazon Web Services Invoice Configuration</b>
 * </p>
 * <p>
 * You can use Amazon Web Services Invoice Configuration APIs to programmatically create, update, delete, get, and list
 * invoice units. You can also programmatically fetch the information of the invoice receiver. For example, business
 * legal name, address, and invoicing contacts.
 * </p>
 * <p>
 * You can use Amazon Web Services Invoice Configuration to receive separate Amazon Web Services invoices based your
 * organizational needs. By using Amazon Web Services Invoice Configuration, you can configure invoice units that are
 * groups of Amazon Web Services accounts that represent your business entities, and receive separate invoices for each
 * business entity. You can also assign a unique member or payer account as the invoice receiver for each invoice unit.
 * As you create new accounts within your Organizations using Amazon Web Services Invoice Configuration APIs, you can
 * automate the creation of new invoice units and subsequently automate the addition of new accounts to your invoice
 * units.
 * </p>
 * <p>
 * <b>Amazon Web Services Procurement Portal Preferences</b>
 * </p>
 * <p>
 * You can use Amazon Web Services Procurement Portal Preferences APIs to programmatically create, update, delete, get,
 * and list procurement portal connections and e-invoice delivery settings. You can also programmatically fetch and
 * modify the status of procurement portal configurations. For example, SAP Business Network or Coupa connections,
 * configure e-invoice delivery and purchase order retrieval features.
 * </p>
 * <p>
 * You can use Amazon Web Services Procurement Portal Preferences to connect e-invoice delivery to your procurement
 * portals based on your organizational needs. By using Amazon Web Services Procurement Portal Preferences, you can
 * configure connections to SAP Business Network and Coupa procurement portals that retrieve purchase orders and deliver
 * Amazon Web Services invoices on the same day they are generated. You can also set up testing environments to validate
 * invoice delivery without affecting live transactions, and manage contact information for portal setup and support.
 * </p>
 * <p>
 * Administrative users should understand that billing read-only policies will show all procurement portal connection
 * details. Review your IAM policies to ensure appropriate access controls are in place for procurement portal
 * preferences.
 * </p>
 * <p>
 * <b>Amazon Web Services Invoice Management</b>
 * </p>
 * <p>
 * You can use Amazon Web Services Invoice Management APIs to programmatically list invoice summaries and get invoice
 * documents. You can also programmatically fetch invoice documents with S3 pre-signed URLs.
 * </p>
 * <p>
 * You can use Amazon Web Services Invoice Management to access invoice information based on your organizational needs.
 * By using Amazon Web Services Invoice Management, you can retrieve paginated lists of invoice summaries that include
 * invoice metadata such as invoice IDs, amounts, and currencies without downloading documents. You can also download
 * invoice documents in PDF format using S3 pre-signed URLs with built-in expiration. As you manage invoices across your
 * organization using Amazon Web Services Invoice Management APIs, you can create invoice retrieval processes and
 * integrate invoice data into your financial systems.
 * </p>
 * <p>
 * Service endpoint
 * </p>
 * <p>
 * You can use the following endpoints for Amazon Web Services Invoice Configuration, Amazon Web Services Procurement
 * Portal Preferences, and Amazon Web Services Invoice Management:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>https://invoicing.us-east-1.api.aws</code>
 * </p>
 * </li>
 * </ul>
 */
package software.amazon.awssdk.services.invoicing;