/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies criteria for selecting which invoices should be processed using a particular procurement portal preference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcurementPortalPreferenceSelector implements SdkPojo, Serializable,
        ToCopyableBuilder<ProcurementPortalPreferenceSelector.Builder, ProcurementPortalPreferenceSelector> {
    private static final SdkField<List<String>> INVOICE_UNIT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InvoiceUnitArns")
            .getter(getter(ProcurementPortalPreferenceSelector::invoiceUnitArns))
            .setter(setter(Builder::invoiceUnitArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceUnitArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SELLER_OF_RECORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SellerOfRecords")
            .getter(getter(ProcurementPortalPreferenceSelector::sellerOfRecords))
            .setter(setter(Builder::sellerOfRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SellerOfRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOICE_UNIT_ARNS_FIELD,
            SELLER_OF_RECORDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> invoiceUnitArns;

    private final List<String> sellerOfRecords;

    private ProcurementPortalPreferenceSelector(BuilderImpl builder) {
        this.invoiceUnitArns = builder.invoiceUnitArns;
        this.sellerOfRecords = builder.sellerOfRecords;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvoiceUnitArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvoiceUnitArns() {
        return invoiceUnitArns != null && !(invoiceUnitArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of invoice unit identifiers to which this preference applies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvoiceUnitArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of invoice unit identifiers to which this preference applies.
     */
    public final List<String> invoiceUnitArns() {
        return invoiceUnitArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the SellerOfRecords property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSellerOfRecords() {
        return sellerOfRecords != null && !(sellerOfRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of seller of record IDs to which this preference applies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSellerOfRecords} method.
     * </p>
     * 
     * @return The list of seller of record IDs to which this preference applies.
     */
    public final List<String> sellerOfRecords() {
        return sellerOfRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInvoiceUnitArns() ? invoiceUnitArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSellerOfRecords() ? sellerOfRecords() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcurementPortalPreferenceSelector)) {
            return false;
        }
        ProcurementPortalPreferenceSelector other = (ProcurementPortalPreferenceSelector) obj;
        return hasInvoiceUnitArns() == other.hasInvoiceUnitArns() && Objects.equals(invoiceUnitArns(), other.invoiceUnitArns())
                && hasSellerOfRecords() == other.hasSellerOfRecords()
                && Objects.equals(sellerOfRecords(), other.sellerOfRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProcurementPortalPreferenceSelector")
                .add("InvoiceUnitArns", hasInvoiceUnitArns() ? invoiceUnitArns() : null)
                .add("SellerOfRecords", hasSellerOfRecords() ? sellerOfRecords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvoiceUnitArns":
            return Optional.ofNullable(clazz.cast(invoiceUnitArns()));
        case "SellerOfRecords":
            return Optional.ofNullable(clazz.cast(sellerOfRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InvoiceUnitArns", INVOICE_UNIT_ARNS_FIELD);
        map.put("SellerOfRecords", SELLER_OF_RECORDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProcurementPortalPreferenceSelector, T> g) {
        return obj -> g.apply((ProcurementPortalPreferenceSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcurementPortalPreferenceSelector> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of invoice unit identifiers to which this preference applies.
         * </p>
         * 
         * @param invoiceUnitArns
         *        The Amazon Resource Name (ARN) of invoice unit identifiers to which this preference applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceUnitArns(Collection<String> invoiceUnitArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of invoice unit identifiers to which this preference applies.
         * </p>
         * 
         * @param invoiceUnitArns
         *        The Amazon Resource Name (ARN) of invoice unit identifiers to which this preference applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceUnitArns(String... invoiceUnitArns);

        /**
         * <p>
         * The list of seller of record IDs to which this preference applies.
         * </p>
         * 
         * @param sellerOfRecords
         *        The list of seller of record IDs to which this preference applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sellerOfRecords(Collection<String> sellerOfRecords);

        /**
         * <p>
         * The list of seller of record IDs to which this preference applies.
         * </p>
         * 
         * @param sellerOfRecords
         *        The list of seller of record IDs to which this preference applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sellerOfRecords(String... sellerOfRecords);
    }

    static final class BuilderImpl implements Builder {
        private List<String> invoiceUnitArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> sellerOfRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProcurementPortalPreferenceSelector model) {
            invoiceUnitArns(model.invoiceUnitArns);
            sellerOfRecords(model.sellerOfRecords);
        }

        public final Collection<String> getInvoiceUnitArns() {
            if (invoiceUnitArns instanceof SdkAutoConstructList) {
                return null;
            }
            return invoiceUnitArns;
        }

        public final void setInvoiceUnitArns(Collection<String> invoiceUnitArns) {
            this.invoiceUnitArns = InvoiceUnitArnsCopier.copy(invoiceUnitArns);
        }

        @Override
        public final Builder invoiceUnitArns(Collection<String> invoiceUnitArns) {
            this.invoiceUnitArns = InvoiceUnitArnsCopier.copy(invoiceUnitArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invoiceUnitArns(String... invoiceUnitArns) {
            invoiceUnitArns(Arrays.asList(invoiceUnitArns));
            return this;
        }

        public final Collection<String> getSellerOfRecords() {
            if (sellerOfRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return sellerOfRecords;
        }

        public final void setSellerOfRecords(Collection<String> sellerOfRecords) {
            this.sellerOfRecords = SellerOfRecordsCopier.copy(sellerOfRecords);
        }

        @Override
        public final Builder sellerOfRecords(Collection<String> sellerOfRecords) {
            this.sellerOfRecords = SellerOfRecordsCopier.copy(sellerOfRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sellerOfRecords(String... sellerOfRecords) {
            sellerOfRecords(Arrays.asList(sellerOfRecords));
            return this;
        }

        @Override
        public ProcurementPortalPreferenceSelector build() {
            return new ProcurementPortalPreferenceSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
