/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the invoice summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvoiceSummariesSelector implements SdkPojo, Serializable,
        ToCopyableBuilder<InvoiceSummariesSelector.Builder, InvoiceSummariesSelector> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(InvoiceSummariesSelector::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(InvoiceSummariesSelector::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final String value;

    private InvoiceSummariesSelector(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.value = builder.value;
    }

    /**
     * <p>
     * The query identifier type (<code>INVOICE_ID</code> or <code>ACCOUNT_ID</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ListInvoiceSummariesResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The query identifier type (<code>INVOICE_ID</code> or <code>ACCOUNT_ID</code>).
     * @see ListInvoiceSummariesResourceType
     */
    public final ListInvoiceSummariesResourceType resourceType() {
        return ListInvoiceSummariesResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The query identifier type (<code>INVOICE_ID</code> or <code>ACCOUNT_ID</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ListInvoiceSummariesResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The query identifier type (<code>INVOICE_ID</code> or <code>ACCOUNT_ID</code>).
     * @see ListInvoiceSummariesResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The value of the query identifier.
     * </p>
     * 
     * @return The value of the query identifier.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvoiceSummariesSelector)) {
            return false;
        }
        InvoiceSummariesSelector other = (InvoiceSummariesSelector) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvoiceSummariesSelector").add("ResourceType", resourceTypeAsString()).add("Value", value())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvoiceSummariesSelector, T> g) {
        return obj -> g.apply((InvoiceSummariesSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvoiceSummariesSelector> {
        /**
         * <p>
         * The query identifier type (<code>INVOICE_ID</code> or <code>ACCOUNT_ID</code>).
         * </p>
         * 
         * @param resourceType
         *        The query identifier type (<code>INVOICE_ID</code> or <code>ACCOUNT_ID</code>).
         * @see ListInvoiceSummariesResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListInvoiceSummariesResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The query identifier type (<code>INVOICE_ID</code> or <code>ACCOUNT_ID</code>).
         * </p>
         * 
         * @param resourceType
         *        The query identifier type (<code>INVOICE_ID</code> or <code>ACCOUNT_ID</code>).
         * @see ListInvoiceSummariesResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListInvoiceSummariesResourceType
         */
        Builder resourceType(ListInvoiceSummariesResourceType resourceType);

        /**
         * <p>
         * The value of the query identifier.
         * </p>
         * 
         * @param value
         *        The value of the query identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(InvoiceSummariesSelector model) {
            resourceType(model.resourceType);
            value(model.value);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ListInvoiceSummariesResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public InvoiceSummariesSelector build() {
            return new InvoiceSummariesSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
