/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters for your invoice summaries.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvoiceSummariesFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<InvoiceSummariesFilter.Builder, InvoiceSummariesFilter> {
    private static final SdkField<DateInterval> TIME_INTERVAL_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .memberName("TimeInterval").getter(getter(InvoiceSummariesFilter::timeInterval))
            .setter(setter(Builder::timeInterval)).constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeInterval").build()).build();

    private static final SdkField<BillingPeriod> BILLING_PERIOD_FIELD = SdkField
            .<BillingPeriod> builder(MarshallingType.SDK_POJO).memberName("BillingPeriod")
            .getter(getter(InvoiceSummariesFilter::billingPeriod)).setter(setter(Builder::billingPeriod))
            .constructor(BillingPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriod").build()).build();

    private static final SdkField<String> INVOICING_ENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvoicingEntity").getter(getter(InvoiceSummariesFilter::invoicingEntity))
            .setter(setter(Builder::invoicingEntity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoicingEntity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_INTERVAL_FIELD,
            BILLING_PERIOD_FIELD, INVOICING_ENTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DateInterval timeInterval;

    private final BillingPeriod billingPeriod;

    private final String invoicingEntity;

    private InvoiceSummariesFilter(BuilderImpl builder) {
        this.timeInterval = builder.timeInterval;
        this.billingPeriod = builder.billingPeriod;
        this.invoicingEntity = builder.invoicingEntity;
    }

    /**
     * <p>
     * The date range for invoice summary retrieval.
     * </p>
     * 
     * @return The date range for invoice summary retrieval.
     */
    public final DateInterval timeInterval() {
        return timeInterval;
    }

    /**
     * <p>
     * The billing period associated with the invoice documents.
     * </p>
     * 
     * @return The billing period associated with the invoice documents.
     */
    public final BillingPeriod billingPeriod() {
        return billingPeriod;
    }

    /**
     * <p>
     * The name of the entity that issues the Amazon Web Services invoice.
     * </p>
     * 
     * @return The name of the entity that issues the Amazon Web Services invoice.
     */
    public final String invoicingEntity() {
        return invoicingEntity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeInterval());
        hashCode = 31 * hashCode + Objects.hashCode(billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(invoicingEntity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvoiceSummariesFilter)) {
            return false;
        }
        InvoiceSummariesFilter other = (InvoiceSummariesFilter) obj;
        return Objects.equals(timeInterval(), other.timeInterval()) && Objects.equals(billingPeriod(), other.billingPeriod())
                && Objects.equals(invoicingEntity(), other.invoicingEntity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvoiceSummariesFilter").add("TimeInterval", timeInterval())
                .add("BillingPeriod", billingPeriod()).add("InvoicingEntity", invoicingEntity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeInterval":
            return Optional.ofNullable(clazz.cast(timeInterval()));
        case "BillingPeriod":
            return Optional.ofNullable(clazz.cast(billingPeriod()));
        case "InvoicingEntity":
            return Optional.ofNullable(clazz.cast(invoicingEntity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimeInterval", TIME_INTERVAL_FIELD);
        map.put("BillingPeriod", BILLING_PERIOD_FIELD);
        map.put("InvoicingEntity", INVOICING_ENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvoiceSummariesFilter, T> g) {
        return obj -> g.apply((InvoiceSummariesFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvoiceSummariesFilter> {
        /**
         * <p>
         * The date range for invoice summary retrieval.
         * </p>
         * 
         * @param timeInterval
         *        The date range for invoice summary retrieval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeInterval(DateInterval timeInterval);

        /**
         * <p>
         * The date range for invoice summary retrieval.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateInterval.Builder} avoiding the need
         * to create one manually via {@link DateInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timeInterval(DateInterval)}.
         * 
         * @param timeInterval
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeInterval(DateInterval)
         */
        default Builder timeInterval(Consumer<DateInterval.Builder> timeInterval) {
            return timeInterval(DateInterval.builder().applyMutation(timeInterval).build());
        }

        /**
         * <p>
         * The billing period associated with the invoice documents.
         * </p>
         * 
         * @param billingPeriod
         *        The billing period associated with the invoice documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingPeriod(BillingPeriod billingPeriod);

        /**
         * <p>
         * The billing period associated with the invoice documents.
         * </p>
         * This is a convenience method that creates an instance of the {@link BillingPeriod.Builder} avoiding the need
         * to create one manually via {@link BillingPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BillingPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #billingPeriod(BillingPeriod)}.
         * 
         * @param billingPeriod
         *        a consumer that will call methods on {@link BillingPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingPeriod(BillingPeriod)
         */
        default Builder billingPeriod(Consumer<BillingPeriod.Builder> billingPeriod) {
            return billingPeriod(BillingPeriod.builder().applyMutation(billingPeriod).build());
        }

        /**
         * <p>
         * The name of the entity that issues the Amazon Web Services invoice.
         * </p>
         * 
         * @param invoicingEntity
         *        The name of the entity that issues the Amazon Web Services invoice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoicingEntity(String invoicingEntity);
    }

    static final class BuilderImpl implements Builder {
        private DateInterval timeInterval;

        private BillingPeriod billingPeriod;

        private String invoicingEntity;

        private BuilderImpl() {
        }

        private BuilderImpl(InvoiceSummariesFilter model) {
            timeInterval(model.timeInterval);
            billingPeriod(model.billingPeriod);
            invoicingEntity(model.invoicingEntity);
        }

        public final DateInterval.Builder getTimeInterval() {
            return timeInterval != null ? timeInterval.toBuilder() : null;
        }

        public final void setTimeInterval(DateInterval.BuilderImpl timeInterval) {
            this.timeInterval = timeInterval != null ? timeInterval.build() : null;
        }

        @Override
        public final Builder timeInterval(DateInterval timeInterval) {
            this.timeInterval = timeInterval;
            return this;
        }

        public final BillingPeriod.Builder getBillingPeriod() {
            return billingPeriod != null ? billingPeriod.toBuilder() : null;
        }

        public final void setBillingPeriod(BillingPeriod.BuilderImpl billingPeriod) {
            this.billingPeriod = billingPeriod != null ? billingPeriod.build() : null;
        }

        @Override
        public final Builder billingPeriod(BillingPeriod billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final String getInvoicingEntity() {
            return invoicingEntity;
        }

        public final void setInvoicingEntity(String invoicingEntity) {
            this.invoicingEntity = invoicingEntity;
        }

        @Override
        public final Builder invoicingEntity(String invoicingEntity) {
            this.invoicingEntity = invoicingEntity;
            return this;
        }

        @Override
        public InvoiceSummariesFilter build() {
            return new InvoiceSummariesFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
