/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of currency exchange.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CurrencyExchangeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CurrencyExchangeDetails.Builder, CurrencyExchangeDetails> {
    private static final SdkField<String> SOURCE_CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceCurrencyCode").getter(getter(CurrencyExchangeDetails::sourceCurrencyCode))
            .setter(setter(Builder::sourceCurrencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCurrencyCode").build())
            .build();

    private static final SdkField<String> TARGET_CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetCurrencyCode").getter(getter(CurrencyExchangeDetails::targetCurrencyCode))
            .setter(setter(Builder::targetCurrencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCurrencyCode").build())
            .build();

    private static final SdkField<String> RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Rate")
            .getter(getter(CurrencyExchangeDetails::rate)).setter(setter(Builder::rate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_CURRENCY_CODE_FIELD,
            TARGET_CURRENCY_CODE_FIELD, RATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceCurrencyCode;

    private final String targetCurrencyCode;

    private final String rate;

    private CurrencyExchangeDetails(BuilderImpl builder) {
        this.sourceCurrencyCode = builder.sourceCurrencyCode;
        this.targetCurrencyCode = builder.targetCurrencyCode;
        this.rate = builder.rate;
    }

    /**
     * <p>
     * The exchange source currency.
     * </p>
     * 
     * @return The exchange source currency.
     */
    public final String sourceCurrencyCode() {
        return sourceCurrencyCode;
    }

    /**
     * <p>
     * The exchange target currency.
     * </p>
     * 
     * @return The exchange target currency.
     */
    public final String targetCurrencyCode() {
        return targetCurrencyCode;
    }

    /**
     * <p>
     * The currency exchange rate.
     * </p>
     * 
     * @return The currency exchange rate.
     */
    public final String rate() {
        return rate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceCurrencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(targetCurrencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(rate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrencyExchangeDetails)) {
            return false;
        }
        CurrencyExchangeDetails other = (CurrencyExchangeDetails) obj;
        return Objects.equals(sourceCurrencyCode(), other.sourceCurrencyCode())
                && Objects.equals(targetCurrencyCode(), other.targetCurrencyCode()) && Objects.equals(rate(), other.rate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CurrencyExchangeDetails").add("SourceCurrencyCode", sourceCurrencyCode())
                .add("TargetCurrencyCode", targetCurrencyCode()).add("Rate", rate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceCurrencyCode":
            return Optional.ofNullable(clazz.cast(sourceCurrencyCode()));
        case "TargetCurrencyCode":
            return Optional.ofNullable(clazz.cast(targetCurrencyCode()));
        case "Rate":
            return Optional.ofNullable(clazz.cast(rate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceCurrencyCode", SOURCE_CURRENCY_CODE_FIELD);
        map.put("TargetCurrencyCode", TARGET_CURRENCY_CODE_FIELD);
        map.put("Rate", RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CurrencyExchangeDetails, T> g) {
        return obj -> g.apply((CurrencyExchangeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CurrencyExchangeDetails> {
        /**
         * <p>
         * The exchange source currency.
         * </p>
         * 
         * @param sourceCurrencyCode
         *        The exchange source currency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCurrencyCode(String sourceCurrencyCode);

        /**
         * <p>
         * The exchange target currency.
         * </p>
         * 
         * @param targetCurrencyCode
         *        The exchange target currency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCurrencyCode(String targetCurrencyCode);

        /**
         * <p>
         * The currency exchange rate.
         * </p>
         * 
         * @param rate
         *        The currency exchange rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rate(String rate);
    }

    static final class BuilderImpl implements Builder {
        private String sourceCurrencyCode;

        private String targetCurrencyCode;

        private String rate;

        private BuilderImpl() {
        }

        private BuilderImpl(CurrencyExchangeDetails model) {
            sourceCurrencyCode(model.sourceCurrencyCode);
            targetCurrencyCode(model.targetCurrencyCode);
            rate(model.rate);
        }

        public final String getSourceCurrencyCode() {
            return sourceCurrencyCode;
        }

        public final void setSourceCurrencyCode(String sourceCurrencyCode) {
            this.sourceCurrencyCode = sourceCurrencyCode;
        }

        @Override
        public final Builder sourceCurrencyCode(String sourceCurrencyCode) {
            this.sourceCurrencyCode = sourceCurrencyCode;
            return this;
        }

        public final String getTargetCurrencyCode() {
            return targetCurrencyCode;
        }

        public final void setTargetCurrencyCode(String targetCurrencyCode) {
            this.targetCurrencyCode = targetCurrencyCode;
        }

        @Override
        public final Builder targetCurrencyCode(String targetCurrencyCode) {
            this.targetCurrencyCode = targetCurrencyCode;
            return this;
        }

        public final String getRate() {
            return rate;
        }

        public final void setRate(String rate) {
            this.rate = rate;
        }

        @Override
        public final Builder rate(String rate) {
            this.rate = rate;
            return this;
        }

        @Override
        public CurrencyExchangeDetails build() {
            return new CurrencyExchangeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
