/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about how the total amount was calculated and categorized.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmountBreakdown implements SdkPojo, Serializable, ToCopyableBuilder<AmountBreakdown.Builder, AmountBreakdown> {
    private static final SdkField<String> SUB_TOTAL_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubTotalAmount").getter(getter(AmountBreakdown::subTotalAmount)).setter(setter(Builder::subTotalAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubTotalAmount").build()).build();

    private static final SdkField<DiscountsBreakdown> DISCOUNTS_FIELD = SdkField
            .<DiscountsBreakdown> builder(MarshallingType.SDK_POJO).memberName("Discounts")
            .getter(getter(AmountBreakdown::discounts)).setter(setter(Builder::discounts))
            .constructor(DiscountsBreakdown::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Discounts").build()).build();

    private static final SdkField<TaxesBreakdown> TAXES_FIELD = SdkField.<TaxesBreakdown> builder(MarshallingType.SDK_POJO)
            .memberName("Taxes").getter(getter(AmountBreakdown::taxes)).setter(setter(Builder::taxes))
            .constructor(TaxesBreakdown::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Taxes").build()).build();

    private static final SdkField<FeesBreakdown> FEES_FIELD = SdkField.<FeesBreakdown> builder(MarshallingType.SDK_POJO)
            .memberName("Fees").getter(getter(AmountBreakdown::fees)).setter(setter(Builder::fees))
            .constructor(FeesBreakdown::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fees").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUB_TOTAL_AMOUNT_FIELD,
            DISCOUNTS_FIELD, TAXES_FIELD, FEES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String subTotalAmount;

    private final DiscountsBreakdown discounts;

    private final TaxesBreakdown taxes;

    private final FeesBreakdown fees;

    private AmountBreakdown(BuilderImpl builder) {
        this.subTotalAmount = builder.subTotalAmount;
        this.discounts = builder.discounts;
        this.taxes = builder.taxes;
        this.fees = builder.fees;
    }

    /**
     * <p>
     * The total of a set of the breakdown.
     * </p>
     * 
     * @return The total of a set of the breakdown.
     */
    public final String subTotalAmount() {
        return subTotalAmount;
    }

    /**
     * <p>
     * The discounted amount.
     * </p>
     * 
     * @return The discounted amount.
     */
    public final DiscountsBreakdown discounts() {
        return discounts;
    }

    /**
     * <p>
     * The tax amount.
     * </p>
     * 
     * @return The tax amount.
     */
    public final TaxesBreakdown taxes() {
        return taxes;
    }

    /**
     * <p>
     * The fee amount.
     * </p>
     * 
     * @return The fee amount.
     */
    public final FeesBreakdown fees() {
        return fees;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subTotalAmount());
        hashCode = 31 * hashCode + Objects.hashCode(discounts());
        hashCode = 31 * hashCode + Objects.hashCode(taxes());
        hashCode = 31 * hashCode + Objects.hashCode(fees());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmountBreakdown)) {
            return false;
        }
        AmountBreakdown other = (AmountBreakdown) obj;
        return Objects.equals(subTotalAmount(), other.subTotalAmount()) && Objects.equals(discounts(), other.discounts())
                && Objects.equals(taxes(), other.taxes()) && Objects.equals(fees(), other.fees());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmountBreakdown").add("SubTotalAmount", subTotalAmount()).add("Discounts", discounts())
                .add("Taxes", taxes()).add("Fees", fees()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubTotalAmount":
            return Optional.ofNullable(clazz.cast(subTotalAmount()));
        case "Discounts":
            return Optional.ofNullable(clazz.cast(discounts()));
        case "Taxes":
            return Optional.ofNullable(clazz.cast(taxes()));
        case "Fees":
            return Optional.ofNullable(clazz.cast(fees()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SubTotalAmount", SUB_TOTAL_AMOUNT_FIELD);
        map.put("Discounts", DISCOUNTS_FIELD);
        map.put("Taxes", TAXES_FIELD);
        map.put("Fees", FEES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmountBreakdown, T> g) {
        return obj -> g.apply((AmountBreakdown) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmountBreakdown> {
        /**
         * <p>
         * The total of a set of the breakdown.
         * </p>
         * 
         * @param subTotalAmount
         *        The total of a set of the breakdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subTotalAmount(String subTotalAmount);

        /**
         * <p>
         * The discounted amount.
         * </p>
         * 
         * @param discounts
         *        The discounted amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discounts(DiscountsBreakdown discounts);

        /**
         * <p>
         * The discounted amount.
         * </p>
         * This is a convenience method that creates an instance of the {@link DiscountsBreakdown.Builder} avoiding the
         * need to create one manually via {@link DiscountsBreakdown#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DiscountsBreakdown.Builder#build()} is called immediately and its
         * result is passed to {@link #discounts(DiscountsBreakdown)}.
         * 
         * @param discounts
         *        a consumer that will call methods on {@link DiscountsBreakdown.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #discounts(DiscountsBreakdown)
         */
        default Builder discounts(Consumer<DiscountsBreakdown.Builder> discounts) {
            return discounts(DiscountsBreakdown.builder().applyMutation(discounts).build());
        }

        /**
         * <p>
         * The tax amount.
         * </p>
         * 
         * @param taxes
         *        The tax amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxes(TaxesBreakdown taxes);

        /**
         * <p>
         * The tax amount.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaxesBreakdown.Builder} avoiding the need
         * to create one manually via {@link TaxesBreakdown#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaxesBreakdown.Builder#build()} is called immediately and its
         * result is passed to {@link #taxes(TaxesBreakdown)}.
         * 
         * @param taxes
         *        a consumer that will call methods on {@link TaxesBreakdown.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxes(TaxesBreakdown)
         */
        default Builder taxes(Consumer<TaxesBreakdown.Builder> taxes) {
            return taxes(TaxesBreakdown.builder().applyMutation(taxes).build());
        }

        /**
         * <p>
         * The fee amount.
         * </p>
         * 
         * @param fees
         *        The fee amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fees(FeesBreakdown fees);

        /**
         * <p>
         * The fee amount.
         * </p>
         * This is a convenience method that creates an instance of the {@link FeesBreakdown.Builder} avoiding the need
         * to create one manually via {@link FeesBreakdown#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FeesBreakdown.Builder#build()} is called immediately and its
         * result is passed to {@link #fees(FeesBreakdown)}.
         * 
         * @param fees
         *        a consumer that will call methods on {@link FeesBreakdown.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fees(FeesBreakdown)
         */
        default Builder fees(Consumer<FeesBreakdown.Builder> fees) {
            return fees(FeesBreakdown.builder().applyMutation(fees).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String subTotalAmount;

        private DiscountsBreakdown discounts;

        private TaxesBreakdown taxes;

        private FeesBreakdown fees;

        private BuilderImpl() {
        }

        private BuilderImpl(AmountBreakdown model) {
            subTotalAmount(model.subTotalAmount);
            discounts(model.discounts);
            taxes(model.taxes);
            fees(model.fees);
        }

        public final String getSubTotalAmount() {
            return subTotalAmount;
        }

        public final void setSubTotalAmount(String subTotalAmount) {
            this.subTotalAmount = subTotalAmount;
        }

        @Override
        public final Builder subTotalAmount(String subTotalAmount) {
            this.subTotalAmount = subTotalAmount;
            return this;
        }

        public final DiscountsBreakdown.Builder getDiscounts() {
            return discounts != null ? discounts.toBuilder() : null;
        }

        public final void setDiscounts(DiscountsBreakdown.BuilderImpl discounts) {
            this.discounts = discounts != null ? discounts.build() : null;
        }

        @Override
        public final Builder discounts(DiscountsBreakdown discounts) {
            this.discounts = discounts;
            return this;
        }

        public final TaxesBreakdown.Builder getTaxes() {
            return taxes != null ? taxes.toBuilder() : null;
        }

        public final void setTaxes(TaxesBreakdown.BuilderImpl taxes) {
            this.taxes = taxes != null ? taxes.build() : null;
        }

        @Override
        public final Builder taxes(TaxesBreakdown taxes) {
            this.taxes = taxes;
            return this;
        }

        public final FeesBreakdown.Builder getFees() {
            return fees != null ? fees.toBuilder() : null;
        }

        public final void setFees(FeesBreakdown.BuilderImpl fees) {
            this.fees = fees != null ? fees.build() : null;
        }

        @Override
        public final Builder fees(FeesBreakdown fees) {
            this.fees = fees;
            return this;
        }

        @Override
        public AmountBreakdown build() {
            return new AmountBreakdown(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
