/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.invoicing.model.InvoiceUnit;
import software.amazon.awssdk.services.invoicing.model.InvoiceUnitsCopier;
import software.amazon.awssdk.services.invoicing.model.InvoicingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInvoiceUnitsResponse
extends InvoicingResponse
implements ToCopyableBuilder<Builder, ListInvoiceUnitsResponse> {
    private static final SdkField<List<InvoiceUnit>> INVOICE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InvoiceUnits").getter(ListInvoiceUnitsResponse.getter(ListInvoiceUnitsResponse::invoiceUnits)).setter(ListInvoiceUnitsResponse.setter(Builder::invoiceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceUnits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvoiceUnit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInvoiceUnitsResponse.getter(ListInvoiceUnitsResponse::nextToken)).setter(ListInvoiceUnitsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOICE_UNITS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInvoiceUnitsResponse.memberNameToFieldInitializer();
    private final List<InvoiceUnit> invoiceUnits;
    private final String nextToken;

    private ListInvoiceUnitsResponse(BuilderImpl builder) {
        super(builder);
        this.invoiceUnits = builder.invoiceUnits;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInvoiceUnits() {
        return this.invoiceUnits != null && !(this.invoiceUnits instanceof SdkAutoConstructList);
    }

    public final List<InvoiceUnit> invoiceUnits() {
        return this.invoiceUnits;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvoiceUnits() ? this.invoiceUnits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvoiceUnitsResponse)) {
            return false;
        }
        ListInvoiceUnitsResponse other = (ListInvoiceUnitsResponse)((Object)obj);
        return this.hasInvoiceUnits() == other.hasInvoiceUnits() && Objects.equals(this.invoiceUnits(), other.invoiceUnits()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInvoiceUnitsResponse").add("InvoiceUnits", this.hasInvoiceUnits() ? this.invoiceUnits() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvoiceUnits": {
                return Optional.ofNullable(clazz.cast(this.invoiceUnits()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InvoiceUnits", INVOICE_UNITS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvoiceUnitsResponse, T> g) {
        return obj -> g.apply((ListInvoiceUnitsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InvoicingResponse.BuilderImpl
    implements Builder {
        private List<InvoiceUnit> invoiceUnits = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvoiceUnitsResponse model) {
            super(model);
            this.invoiceUnits(model.invoiceUnits);
            this.nextToken(model.nextToken);
        }

        public final List<InvoiceUnit.Builder> getInvoiceUnits() {
            List<InvoiceUnit.Builder> result = InvoiceUnitsCopier.copyToBuilder(this.invoiceUnits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvoiceUnits(Collection<InvoiceUnit.BuilderImpl> invoiceUnits) {
            this.invoiceUnits = InvoiceUnitsCopier.copyFromBuilder(invoiceUnits);
        }

        @Override
        public final Builder invoiceUnits(Collection<InvoiceUnit> invoiceUnits) {
            this.invoiceUnits = InvoiceUnitsCopier.copy(invoiceUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invoiceUnits(InvoiceUnit ... invoiceUnits) {
            this.invoiceUnits(Arrays.asList(invoiceUnits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invoiceUnits(Consumer<InvoiceUnit.Builder> ... invoiceUnits) {
            this.invoiceUnits(Stream.of(invoiceUnits).map(c -> (InvoiceUnit)((InvoiceUnit.Builder)InvoiceUnit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInvoiceUnitsResponse build() {
            return new ListInvoiceUnitsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends InvoicingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInvoiceUnitsResponse> {
        public Builder invoiceUnits(Collection<InvoiceUnit> var1);

        public Builder invoiceUnits(InvoiceUnit ... var1);

        public Builder invoiceUnits(Consumer<InvoiceUnit.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

