/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.invoicing.InvoicingClient;
import software.amazon.awssdk.services.invoicing.internal.UserAgentUtils;
import software.amazon.awssdk.services.invoicing.model.InvoiceSummary;
import software.amazon.awssdk.services.invoicing.model.ListInvoiceSummariesRequest;
import software.amazon.awssdk.services.invoicing.model.ListInvoiceSummariesResponse;

public class ListInvoiceSummariesIterable
implements SdkIterable<ListInvoiceSummariesResponse> {
    private final InvoicingClient client;
    private final ListInvoiceSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInvoiceSummariesIterable(InvoicingClient client, ListInvoiceSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInvoiceSummariesResponseFetcher();
    }

    public Iterator<ListInvoiceSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InvoiceSummary> invoiceSummaries() {
        Function<ListInvoiceSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.invoiceSummaries() != null) {
                return response.invoiceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInvoiceSummariesResponseFetcher
    implements SyncPageFetcher<ListInvoiceSummariesResponse> {
        private ListInvoiceSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListInvoiceSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInvoiceSummariesResponse nextPage(ListInvoiceSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListInvoiceSummariesIterable.this.client.listInvoiceSummaries(ListInvoiceSummariesIterable.this.firstRequest);
            }
            return ListInvoiceSummariesIterable.this.client.listInvoiceSummaries((ListInvoiceSummariesRequest)((Object)ListInvoiceSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

