/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.invoicing.model.AmountBreakdown;
import software.amazon.awssdk.services.invoicing.model.CurrencyExchangeDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvoiceCurrencyAmount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvoiceCurrencyAmount> {
    private static final SdkField<String> TOTAL_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalAmount").getter(InvoiceCurrencyAmount.getter(InvoiceCurrencyAmount::totalAmount)).setter(InvoiceCurrencyAmount.setter(Builder::totalAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAmount").build()}).build();
    private static final SdkField<String> TOTAL_AMOUNT_BEFORE_TAX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalAmountBeforeTax").getter(InvoiceCurrencyAmount.getter(InvoiceCurrencyAmount::totalAmountBeforeTax)).setter(InvoiceCurrencyAmount.setter(Builder::totalAmountBeforeTax)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAmountBeforeTax").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(InvoiceCurrencyAmount.getter(InvoiceCurrencyAmount::currencyCode)).setter(InvoiceCurrencyAmount.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<AmountBreakdown> AMOUNT_BREAKDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmountBreakdown").getter(InvoiceCurrencyAmount.getter(InvoiceCurrencyAmount::amountBreakdown)).setter(InvoiceCurrencyAmount.setter(Builder::amountBreakdown)).constructor(AmountBreakdown::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmountBreakdown").build()}).build();
    private static final SdkField<CurrencyExchangeDetails> CURRENCY_EXCHANGE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CurrencyExchangeDetails").getter(InvoiceCurrencyAmount.getter(InvoiceCurrencyAmount::currencyExchangeDetails)).setter(InvoiceCurrencyAmount.setter(Builder::currencyExchangeDetails)).constructor(CurrencyExchangeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyExchangeDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_AMOUNT_FIELD, TOTAL_AMOUNT_BEFORE_TAX_FIELD, CURRENCY_CODE_FIELD, AMOUNT_BREAKDOWN_FIELD, CURRENCY_EXCHANGE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvoiceCurrencyAmount.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String totalAmount;
    private final String totalAmountBeforeTax;
    private final String currencyCode;
    private final AmountBreakdown amountBreakdown;
    private final CurrencyExchangeDetails currencyExchangeDetails;

    private InvoiceCurrencyAmount(BuilderImpl builder) {
        this.totalAmount = builder.totalAmount;
        this.totalAmountBeforeTax = builder.totalAmountBeforeTax;
        this.currencyCode = builder.currencyCode;
        this.amountBreakdown = builder.amountBreakdown;
        this.currencyExchangeDetails = builder.currencyExchangeDetails;
    }

    public final String totalAmount() {
        return this.totalAmount;
    }

    public final String totalAmountBeforeTax() {
        return this.totalAmountBeforeTax;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final AmountBreakdown amountBreakdown() {
        return this.amountBreakdown;
    }

    public final CurrencyExchangeDetails currencyExchangeDetails() {
        return this.currencyExchangeDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAmountBeforeTax());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.amountBreakdown());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyExchangeDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvoiceCurrencyAmount)) {
            return false;
        }
        InvoiceCurrencyAmount other = (InvoiceCurrencyAmount)obj;
        return Objects.equals(this.totalAmount(), other.totalAmount()) && Objects.equals(this.totalAmountBeforeTax(), other.totalAmountBeforeTax()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.amountBreakdown(), other.amountBreakdown()) && Objects.equals(this.currencyExchangeDetails(), other.currencyExchangeDetails());
    }

    public final String toString() {
        return ToString.builder((String)"InvoiceCurrencyAmount").add("TotalAmount", (Object)this.totalAmount()).add("TotalAmountBeforeTax", (Object)this.totalAmountBeforeTax()).add("CurrencyCode", (Object)this.currencyCode()).add("AmountBreakdown", (Object)this.amountBreakdown()).add("CurrencyExchangeDetails", (Object)this.currencyExchangeDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalAmount": {
                return Optional.ofNullable(clazz.cast(this.totalAmount()));
            }
            case "TotalAmountBeforeTax": {
                return Optional.ofNullable(clazz.cast(this.totalAmountBeforeTax()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "AmountBreakdown": {
                return Optional.ofNullable(clazz.cast(this.amountBreakdown()));
            }
            case "CurrencyExchangeDetails": {
                return Optional.ofNullable(clazz.cast(this.currencyExchangeDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TotalAmount", TOTAL_AMOUNT_FIELD);
        map.put("TotalAmountBeforeTax", TOTAL_AMOUNT_BEFORE_TAX_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("AmountBreakdown", AMOUNT_BREAKDOWN_FIELD);
        map.put("CurrencyExchangeDetails", CURRENCY_EXCHANGE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvoiceCurrencyAmount, T> g) {
        return obj -> g.apply((InvoiceCurrencyAmount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String totalAmount;
        private String totalAmountBeforeTax;
        private String currencyCode;
        private AmountBreakdown amountBreakdown;
        private CurrencyExchangeDetails currencyExchangeDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(InvoiceCurrencyAmount model) {
            this.totalAmount(model.totalAmount);
            this.totalAmountBeforeTax(model.totalAmountBeforeTax);
            this.currencyCode(model.currencyCode);
            this.amountBreakdown(model.amountBreakdown);
            this.currencyExchangeDetails(model.currencyExchangeDetails);
        }

        public final String getTotalAmount() {
            return this.totalAmount;
        }

        public final void setTotalAmount(String totalAmount) {
            this.totalAmount = totalAmount;
        }

        @Override
        public final Builder totalAmount(String totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public final String getTotalAmountBeforeTax() {
            return this.totalAmountBeforeTax;
        }

        public final void setTotalAmountBeforeTax(String totalAmountBeforeTax) {
            this.totalAmountBeforeTax = totalAmountBeforeTax;
        }

        @Override
        public final Builder totalAmountBeforeTax(String totalAmountBeforeTax) {
            this.totalAmountBeforeTax = totalAmountBeforeTax;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final AmountBreakdown.Builder getAmountBreakdown() {
            return this.amountBreakdown != null ? this.amountBreakdown.toBuilder() : null;
        }

        public final void setAmountBreakdown(AmountBreakdown.BuilderImpl amountBreakdown) {
            this.amountBreakdown = amountBreakdown != null ? amountBreakdown.build() : null;
        }

        @Override
        public final Builder amountBreakdown(AmountBreakdown amountBreakdown) {
            this.amountBreakdown = amountBreakdown;
            return this;
        }

        public final CurrencyExchangeDetails.Builder getCurrencyExchangeDetails() {
            return this.currencyExchangeDetails != null ? this.currencyExchangeDetails.toBuilder() : null;
        }

        public final void setCurrencyExchangeDetails(CurrencyExchangeDetails.BuilderImpl currencyExchangeDetails) {
            this.currencyExchangeDetails = currencyExchangeDetails != null ? currencyExchangeDetails.build() : null;
        }

        @Override
        public final Builder currencyExchangeDetails(CurrencyExchangeDetails currencyExchangeDetails) {
            this.currencyExchangeDetails = currencyExchangeDetails;
            return this;
        }

        public InvoiceCurrencyAmount build() {
            return new InvoiceCurrencyAmount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvoiceCurrencyAmount> {
        public Builder totalAmount(String var1);

        public Builder totalAmountBeforeTax(String var1);

        public Builder currencyCode(String var1);

        public Builder amountBreakdown(AmountBreakdown var1);

        default public Builder amountBreakdown(Consumer<AmountBreakdown.Builder> amountBreakdown) {
            return this.amountBreakdown((AmountBreakdown)((AmountBreakdown.Builder)AmountBreakdown.builder().applyMutation(amountBreakdown)).build());
        }

        public Builder currencyExchangeDetails(CurrencyExchangeDetails var1);

        default public Builder currencyExchangeDetails(Consumer<CurrencyExchangeDetails.Builder> currencyExchangeDetails) {
            return this.currencyExchangeDetails((CurrencyExchangeDetails)((CurrencyExchangeDetails.Builder)CurrencyExchangeDetails.builder().applyMutation(currencyExchangeDetails)).build());
        }
    }
}

