/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BillingPeriod
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BillingPeriod> {
    private static final SdkField<Integer> MONTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Month").getter(BillingPeriod.getter(BillingPeriod::month)).setter(BillingPeriod.setter(Builder::month)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Month").build()}).build();
    private static final SdkField<Integer> YEAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Year").getter(BillingPeriod.getter(BillingPeriod::year)).setter(BillingPeriod.setter(Builder::year)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Year").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONTH_FIELD, YEAR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BillingPeriod.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer month;
    private final Integer year;

    private BillingPeriod(BuilderImpl builder) {
        this.month = builder.month;
        this.year = builder.year;
    }

    public final Integer month() {
        return this.month;
    }

    public final Integer year() {
        return this.year;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.month());
        hashCode = 31 * hashCode + Objects.hashCode(this.year());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingPeriod)) {
            return false;
        }
        BillingPeriod other = (BillingPeriod)obj;
        return Objects.equals(this.month(), other.month()) && Objects.equals(this.year(), other.year());
    }

    public final String toString() {
        return ToString.builder((String)"BillingPeriod").add("Month", (Object)this.month()).add("Year", (Object)this.year()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Month": {
                return Optional.ofNullable(clazz.cast(this.month()));
            }
            case "Year": {
                return Optional.ofNullable(clazz.cast(this.year()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("Month", MONTH_FIELD);
        map.put("Year", YEAR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillingPeriod, T> g) {
        return obj -> g.apply((BillingPeriod)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer month;
        private Integer year;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingPeriod model) {
            this.month(model.month);
            this.year(model.year);
        }

        public final Integer getMonth() {
            return this.month;
        }

        public final void setMonth(Integer month) {
            this.month = month;
        }

        @Override
        public final Builder month(Integer month) {
            this.month = month;
            return this;
        }

        public final Integer getYear() {
            return this.year;
        }

        public final void setYear(Integer year) {
            this.year = year;
        }

        @Override
        public final Builder year(Integer year) {
            this.year = year;
            return this;
        }

        public BillingPeriod build() {
            return new BillingPeriod(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BillingPeriod> {
        public Builder month(Integer var1);

        public Builder year(Integer var1);
    }
}

