/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.invoicing.model.InvoiceUnitRule;
import software.amazon.awssdk.services.invoicing.model.InvoicingRequest;
import software.amazon.awssdk.services.invoicing.model.ResourceTag;
import software.amazon.awssdk.services.invoicing.model.ResourceTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInvoiceUnitRequest
extends InvoicingRequest
implements ToCopyableBuilder<Builder, CreateInvoiceUnitRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateInvoiceUnitRequest.getter(CreateInvoiceUnitRequest::name)).setter(CreateInvoiceUnitRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> INVOICE_RECEIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvoiceReceiver").getter(CreateInvoiceUnitRequest.getter(CreateInvoiceUnitRequest::invoiceReceiver)).setter(CreateInvoiceUnitRequest.setter(Builder::invoiceReceiver)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceReceiver").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateInvoiceUnitRequest.getter(CreateInvoiceUnitRequest::description)).setter(CreateInvoiceUnitRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> TAX_INHERITANCE_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TaxInheritanceDisabled").getter(CreateInvoiceUnitRequest.getter(CreateInvoiceUnitRequest::taxInheritanceDisabled)).setter(CreateInvoiceUnitRequest.setter(Builder::taxInheritanceDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaxInheritanceDisabled").build()}).build();
    private static final SdkField<InvoiceUnitRule> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rule").getter(CreateInvoiceUnitRequest.getter(CreateInvoiceUnitRequest::rule)).setter(CreateInvoiceUnitRequest.setter(Builder::rule)).constructor(InvoiceUnitRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()}).build();
    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTags").getter(CreateInvoiceUnitRequest.getter(CreateInvoiceUnitRequest::resourceTags)).setter(CreateInvoiceUnitRequest.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INVOICE_RECEIVER_FIELD, DESCRIPTION_FIELD, TAX_INHERITANCE_DISABLED_FIELD, RULE_FIELD, RESOURCE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateInvoiceUnitRequest.memberNameToFieldInitializer();
    private final String name;
    private final String invoiceReceiver;
    private final String description;
    private final Boolean taxInheritanceDisabled;
    private final InvoiceUnitRule rule;
    private final List<ResourceTag> resourceTags;

    private CreateInvoiceUnitRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.invoiceReceiver = builder.invoiceReceiver;
        this.description = builder.description;
        this.taxInheritanceDisabled = builder.taxInheritanceDisabled;
        this.rule = builder.rule;
        this.resourceTags = builder.resourceTags;
    }

    public final String name() {
        return this.name;
    }

    public final String invoiceReceiver() {
        return this.invoiceReceiver;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean taxInheritanceDisabled() {
        return this.taxInheritanceDisabled;
    }

    public final InvoiceUnitRule rule() {
        return this.rule;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.invoiceReceiver());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.taxInheritanceDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvoiceUnitRequest)) {
            return false;
        }
        CreateInvoiceUnitRequest other = (CreateInvoiceUnitRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.invoiceReceiver(), other.invoiceReceiver()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.taxInheritanceDisabled(), other.taxInheritanceDisabled()) && Objects.equals(this.rule(), other.rule()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInvoiceUnitRequest").add("Name", (Object)this.name()).add("InvoiceReceiver", (Object)this.invoiceReceiver()).add("Description", (Object)this.description()).add("TaxInheritanceDisabled", (Object)this.taxInheritanceDisabled()).add("Rule", (Object)this.rule()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "InvoiceReceiver": {
                return Optional.ofNullable(clazz.cast(this.invoiceReceiver()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "TaxInheritanceDisabled": {
                return Optional.ofNullable(clazz.cast(this.taxInheritanceDisabled()));
            }
            case "Rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("InvoiceReceiver", INVOICE_RECEIVER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("TaxInheritanceDisabled", TAX_INHERITANCE_DISABLED_FIELD);
        map.put("Rule", RULE_FIELD);
        map.put("ResourceTags", RESOURCE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInvoiceUnitRequest, T> g) {
        return obj -> g.apply((CreateInvoiceUnitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InvoicingRequest.BuilderImpl
    implements Builder {
        private String name;
        private String invoiceReceiver;
        private String description;
        private Boolean taxInheritanceDisabled;
        private InvoiceUnitRule rule;
        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvoiceUnitRequest model) {
            super(model);
            this.name(model.name);
            this.invoiceReceiver(model.invoiceReceiver);
            this.description(model.description);
            this.taxInheritanceDisabled(model.taxInheritanceDisabled);
            this.rule(model.rule);
            this.resourceTags(model.resourceTags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInvoiceReceiver() {
            return this.invoiceReceiver;
        }

        public final void setInvoiceReceiver(String invoiceReceiver) {
            this.invoiceReceiver = invoiceReceiver;
        }

        @Override
        public final Builder invoiceReceiver(String invoiceReceiver) {
            this.invoiceReceiver = invoiceReceiver;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getTaxInheritanceDisabled() {
            return this.taxInheritanceDisabled;
        }

        public final void setTaxInheritanceDisabled(Boolean taxInheritanceDisabled) {
            this.taxInheritanceDisabled = taxInheritanceDisabled;
        }

        @Override
        public final Builder taxInheritanceDisabled(Boolean taxInheritanceDisabled) {
            this.taxInheritanceDisabled = taxInheritanceDisabled;
            return this;
        }

        public final InvoiceUnitRule.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        public final void setRule(InvoiceUnitRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(InvoiceUnitRule rule) {
            this.rule = rule;
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInvoiceUnitRequest build() {
            return new CreateInvoiceUnitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends InvoicingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInvoiceUnitRequest> {
        public Builder name(String var1);

        public Builder invoiceReceiver(String var1);

        public Builder description(String var1);

        public Builder taxInheritanceDisabled(Boolean var1);

        public Builder rule(InvoiceUnitRule var1);

        default public Builder rule(Consumer<InvoiceUnitRule.Builder> rule) {
            return this.rule((InvoiceUnitRule)((InvoiceUnitRule.Builder)InvoiceUnitRule.builder().applyMutation(rule)).build());
        }

        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);

        public Builder resourceTags(Consumer<ResourceTag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

