/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationExceptionReason {
    NON_MEMBER_PRESENT("nonMemberPresent"),
    MAX_ACCOUNTS_EXCEEDED("maxAccountsExceeded"),
    MAX_INVOICE_UNITS_EXCEEDED("maxInvoiceUnitsExceeded"),
    DUPLICATE_INVOICE_UNIT("duplicateInvoiceUnit"),
    MUTUAL_EXCLUSION_ERROR("mutualExclusionError"),
    ACCOUNT_MEMBERSHIP_ERROR("accountMembershipError"),
    TAX_SETTINGS_ERROR("taxSettingsError"),
    EXPIRED_NEXT_TOKEN("expiredNextToken"),
    INVALID_NEXT_TOKEN("invalidNextToken"),
    INVALID_INPUT("invalidInput"),
    FIELD_VALIDATION_FAILED("fieldValidationFailed"),
    CANNOT_PARSE("cannotParse"),
    UNKNOWN_OPERATION("unknownOperation"),
    OTHER("other"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationExceptionReason> VALUE_MAP;
    private final String value;

    private ValidationExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationExceptionReason> knownValues() {
        EnumSet<ValidationExceptionReason> knownValues = EnumSet.allOf(ValidationExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationExceptionReason.class, ValidationExceptionReason::toString);
    }
}

