/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for publishing Amazon CloudWatch Internet Monitor internet measurements to Amazon S3. The
 * configuration includes the bucket name and (optionally) prefix for the S3 bucket to store the measurements, and the
 * delivery status. The delivery status is <code>ENABLED</code> or <code>DISABLED</code>, depending on whether you
 * choose to deliver internet measurements to S3 logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Config implements SdkPojo, Serializable, ToCopyableBuilder<S3Config.Builder, S3Config> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketName").getter(getter(S3Config::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketPrefix").getter(getter(S3Config::bucketPrefix)).setter(setter(Builder::bucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketPrefix").build()).build();

    private static final SdkField<String> LOG_DELIVERY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogDeliveryStatus").getter(getter(S3Config::logDeliveryStatusAsString))
            .setter(setter(Builder::logDeliveryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            BUCKET_PREFIX_FIELD, LOG_DELIVERY_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String bucketPrefix;

    private final String logDeliveryStatus;

    private S3Config(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.logDeliveryStatus = builder.logDeliveryStatus;
    }

    /**
     * <p>
     * The Amazon S3 bucket name.
     * </p>
     * 
     * @return The Amazon S3 bucket name.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The Amazon S3 bucket prefix.
     * </p>
     * 
     * @return The Amazon S3 bucket prefix.
     */
    public final String bucketPrefix() {
        return bucketPrefix;
    }

    /**
     * <p>
     * The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logDeliveryStatus}
     * will return {@link LogDeliveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logDeliveryStatusAsString}.
     * </p>
     * 
     * @return The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
     * @see LogDeliveryStatus
     */
    public final LogDeliveryStatus logDeliveryStatus() {
        return LogDeliveryStatus.fromValue(logDeliveryStatus);
    }

    /**
     * <p>
     * The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logDeliveryStatus}
     * will return {@link LogDeliveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logDeliveryStatusAsString}.
     * </p>
     * 
     * @return The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
     * @see LogDeliveryStatus
     */
    public final String logDeliveryStatusAsString() {
        return logDeliveryStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(logDeliveryStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Config)) {
            return false;
        }
        S3Config other = (S3Config) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(bucketPrefix(), other.bucketPrefix())
                && Objects.equals(logDeliveryStatusAsString(), other.logDeliveryStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Config").add("BucketName", bucketName()).add("BucketPrefix", bucketPrefix())
                .add("LogDeliveryStatus", logDeliveryStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "BucketPrefix":
            return Optional.ofNullable(clazz.cast(bucketPrefix()));
        case "LogDeliveryStatus":
            return Optional.ofNullable(clazz.cast(logDeliveryStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BucketName", BUCKET_NAME_FIELD);
        map.put("BucketPrefix", BUCKET_PREFIX_FIELD);
        map.put("LogDeliveryStatus", LOG_DELIVERY_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Config, T> g) {
        return obj -> g.apply((S3Config) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Config> {
        /**
         * <p>
         * The Amazon S3 bucket name.
         * </p>
         * 
         * @param bucketName
         *        The Amazon S3 bucket name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The Amazon S3 bucket prefix.
         * </p>
         * 
         * @param bucketPrefix
         *        The Amazon S3 bucket prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketPrefix(String bucketPrefix);

        /**
         * <p>
         * The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
         * </p>
         * 
         * @param logDeliveryStatus
         *        The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
         * @see LogDeliveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogDeliveryStatus
         */
        Builder logDeliveryStatus(String logDeliveryStatus);

        /**
         * <p>
         * The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
         * </p>
         * 
         * @param logDeliveryStatus
         *        The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
         * @see LogDeliveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogDeliveryStatus
         */
        Builder logDeliveryStatus(LogDeliveryStatus logDeliveryStatus);
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String bucketPrefix;

        private String logDeliveryStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Config model) {
            bucketName(model.bucketName);
            bucketPrefix(model.bucketPrefix);
            logDeliveryStatus(model.logDeliveryStatus);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketPrefix() {
            return bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final String getLogDeliveryStatus() {
            return logDeliveryStatus;
        }

        public final void setLogDeliveryStatus(String logDeliveryStatus) {
            this.logDeliveryStatus = logDeliveryStatus;
        }

        @Override
        public final Builder logDeliveryStatus(String logDeliveryStatus) {
            this.logDeliveryStatus = logDeliveryStatus;
            return this;
        }

        @Override
        public final Builder logDeliveryStatus(LogDeliveryStatus logDeliveryStatus) {
            this.logDeliveryStatus(logDeliveryStatus == null ? null : logDeliveryStatus.toString());
            return this;
        }

        @Override
        public S3Config build() {
            return new S3Config(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
