/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.internetmonitor.model.RoundTripTime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PerformanceMeasurement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PerformanceMeasurement> {
    private static final SdkField<Double> EXPERIENCE_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ExperienceScore").getter(PerformanceMeasurement.getter(PerformanceMeasurement::experienceScore)).setter(PerformanceMeasurement.setter(Builder::experienceScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperienceScore").build()}).build();
    private static final SdkField<Double> PERCENT_OF_TOTAL_TRAFFIC_IMPACTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("PercentOfTotalTrafficImpacted").getter(PerformanceMeasurement.getter(PerformanceMeasurement::percentOfTotalTrafficImpacted)).setter(PerformanceMeasurement.setter(Builder::percentOfTotalTrafficImpacted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentOfTotalTrafficImpacted").build()}).build();
    private static final SdkField<Double> PERCENT_OF_CLIENT_LOCATION_IMPACTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("PercentOfClientLocationImpacted").getter(PerformanceMeasurement.getter(PerformanceMeasurement::percentOfClientLocationImpacted)).setter(PerformanceMeasurement.setter(Builder::percentOfClientLocationImpacted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentOfClientLocationImpacted").build()}).build();
    private static final SdkField<RoundTripTime> ROUND_TRIP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoundTripTime").getter(PerformanceMeasurement.getter(PerformanceMeasurement::roundTripTime)).setter(PerformanceMeasurement.setter(Builder::roundTripTime)).constructor(RoundTripTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoundTripTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIENCE_SCORE_FIELD, PERCENT_OF_TOTAL_TRAFFIC_IMPACTED_FIELD, PERCENT_OF_CLIENT_LOCATION_IMPACTED_FIELD, ROUND_TRIP_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PerformanceMeasurement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double experienceScore;
    private final Double percentOfTotalTrafficImpacted;
    private final Double percentOfClientLocationImpacted;
    private final RoundTripTime roundTripTime;

    private PerformanceMeasurement(BuilderImpl builder) {
        this.experienceScore = builder.experienceScore;
        this.percentOfTotalTrafficImpacted = builder.percentOfTotalTrafficImpacted;
        this.percentOfClientLocationImpacted = builder.percentOfClientLocationImpacted;
        this.roundTripTime = builder.roundTripTime;
    }

    public final Double experienceScore() {
        return this.experienceScore;
    }

    public final Double percentOfTotalTrafficImpacted() {
        return this.percentOfTotalTrafficImpacted;
    }

    public final Double percentOfClientLocationImpacted() {
        return this.percentOfClientLocationImpacted;
    }

    public final RoundTripTime roundTripTime() {
        return this.roundTripTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.experienceScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentOfTotalTrafficImpacted());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentOfClientLocationImpacted());
        hashCode = 31 * hashCode + Objects.hashCode(this.roundTripTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceMeasurement)) {
            return false;
        }
        PerformanceMeasurement other = (PerformanceMeasurement)obj;
        return Objects.equals(this.experienceScore(), other.experienceScore()) && Objects.equals(this.percentOfTotalTrafficImpacted(), other.percentOfTotalTrafficImpacted()) && Objects.equals(this.percentOfClientLocationImpacted(), other.percentOfClientLocationImpacted()) && Objects.equals(this.roundTripTime(), other.roundTripTime());
    }

    public final String toString() {
        return ToString.builder((String)"PerformanceMeasurement").add("ExperienceScore", (Object)this.experienceScore()).add("PercentOfTotalTrafficImpacted", (Object)this.percentOfTotalTrafficImpacted()).add("PercentOfClientLocationImpacted", (Object)this.percentOfClientLocationImpacted()).add("RoundTripTime", (Object)this.roundTripTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExperienceScore": {
                return Optional.ofNullable(clazz.cast(this.experienceScore()));
            }
            case "PercentOfTotalTrafficImpacted": {
                return Optional.ofNullable(clazz.cast(this.percentOfTotalTrafficImpacted()));
            }
            case "PercentOfClientLocationImpacted": {
                return Optional.ofNullable(clazz.cast(this.percentOfClientLocationImpacted()));
            }
            case "RoundTripTime": {
                return Optional.ofNullable(clazz.cast(this.roundTripTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExperienceScore", EXPERIENCE_SCORE_FIELD);
        map.put("PercentOfTotalTrafficImpacted", PERCENT_OF_TOTAL_TRAFFIC_IMPACTED_FIELD);
        map.put("PercentOfClientLocationImpacted", PERCENT_OF_CLIENT_LOCATION_IMPACTED_FIELD);
        map.put("RoundTripTime", ROUND_TRIP_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PerformanceMeasurement, T> g) {
        return obj -> g.apply((PerformanceMeasurement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double experienceScore;
        private Double percentOfTotalTrafficImpacted;
        private Double percentOfClientLocationImpacted;
        private RoundTripTime roundTripTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceMeasurement model) {
            this.experienceScore(model.experienceScore);
            this.percentOfTotalTrafficImpacted(model.percentOfTotalTrafficImpacted);
            this.percentOfClientLocationImpacted(model.percentOfClientLocationImpacted);
            this.roundTripTime(model.roundTripTime);
        }

        public final Double getExperienceScore() {
            return this.experienceScore;
        }

        public final void setExperienceScore(Double experienceScore) {
            this.experienceScore = experienceScore;
        }

        @Override
        public final Builder experienceScore(Double experienceScore) {
            this.experienceScore = experienceScore;
            return this;
        }

        public final Double getPercentOfTotalTrafficImpacted() {
            return this.percentOfTotalTrafficImpacted;
        }

        public final void setPercentOfTotalTrafficImpacted(Double percentOfTotalTrafficImpacted) {
            this.percentOfTotalTrafficImpacted = percentOfTotalTrafficImpacted;
        }

        @Override
        public final Builder percentOfTotalTrafficImpacted(Double percentOfTotalTrafficImpacted) {
            this.percentOfTotalTrafficImpacted = percentOfTotalTrafficImpacted;
            return this;
        }

        public final Double getPercentOfClientLocationImpacted() {
            return this.percentOfClientLocationImpacted;
        }

        public final void setPercentOfClientLocationImpacted(Double percentOfClientLocationImpacted) {
            this.percentOfClientLocationImpacted = percentOfClientLocationImpacted;
        }

        @Override
        public final Builder percentOfClientLocationImpacted(Double percentOfClientLocationImpacted) {
            this.percentOfClientLocationImpacted = percentOfClientLocationImpacted;
            return this;
        }

        public final RoundTripTime.Builder getRoundTripTime() {
            return this.roundTripTime != null ? this.roundTripTime.toBuilder() : null;
        }

        public final void setRoundTripTime(RoundTripTime.BuilderImpl roundTripTime) {
            this.roundTripTime = roundTripTime != null ? roundTripTime.build() : null;
        }

        @Override
        public final Builder roundTripTime(RoundTripTime roundTripTime) {
            this.roundTripTime = roundTripTime;
            return this;
        }

        public PerformanceMeasurement build() {
            return new PerformanceMeasurement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PerformanceMeasurement> {
        public Builder experienceScore(Double var1);

        public Builder percentOfTotalTrafficImpacted(Double var1);

        public Builder percentOfClientLocationImpacted(Double var1);

        public Builder roundTripTime(RoundTripTime var1);

        default public Builder roundTripTime(Consumer<RoundTripTime.Builder> roundTripTime) {
            return this.roundTripTime((RoundTripTime)((RoundTripTime.Builder)RoundTripTime.builder().applyMutation(roundTripTime)).build());
        }
    }
}

