/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Network
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Network> {
    private static final SdkField<String> AS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ASName").getter(Network.getter(Network::asName)).setter(Network.setter(Builder::asName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ASName").build()}).build();
    private static final SdkField<Long> AS_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ASNumber").getter(Network.getter(Network::asNumber)).setter(Network.setter(Builder::asNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ASNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AS_NAME_FIELD, AS_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Network.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String asName;
    private final Long asNumber;

    private Network(BuilderImpl builder) {
        this.asName = builder.asName;
        this.asNumber = builder.asNumber;
    }

    public final String asName() {
        return this.asName;
    }

    public final Long asNumber() {
        return this.asNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.asName());
        hashCode = 31 * hashCode + Objects.hashCode(this.asNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Network)) {
            return false;
        }
        Network other = (Network)obj;
        return Objects.equals(this.asName(), other.asName()) && Objects.equals(this.asNumber(), other.asNumber());
    }

    public final String toString() {
        return ToString.builder((String)"Network").add("ASName", (Object)this.asName()).add("ASNumber", (Object)this.asNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ASName": {
                return Optional.ofNullable(clazz.cast(this.asName()));
            }
            case "ASNumber": {
                return Optional.ofNullable(clazz.cast(this.asNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ASName", AS_NAME_FIELD);
        map.put("ASNumber", AS_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Network, T> g) {
        return obj -> g.apply((Network)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String asName;
        private Long asNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Network model) {
            this.asName(model.asName);
            this.asNumber(model.asNumber);
        }

        public final String getAsName() {
            return this.asName;
        }

        public final void setAsName(String asName) {
            this.asName = asName;
        }

        @Override
        public final Builder asName(String asName) {
            this.asName = asName;
            return this;
        }

        public final Long getAsNumber() {
            return this.asNumber;
        }

        public final void setAsNumber(Long asNumber) {
            this.asNumber = asNumber;
        }

        @Override
        public final Builder asNumber(Long asNumber) {
            this.asNumber = asNumber;
            return this;
        }

        public Network build() {
            return new Network(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Network> {
        public Builder asName(String var1);

        public Builder asNumber(Long var1);
    }
}

