/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.internetmonitor.model.InternetMonitorResponse;
import software.amazon.awssdk.services.internetmonitor.model.Monitor;
import software.amazon.awssdk.services.internetmonitor.model.MonitorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMonitorsResponse
extends InternetMonitorResponse
implements ToCopyableBuilder<Builder, ListMonitorsResponse> {
    private static final SdkField<List<Monitor>> MONITORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Monitors").getter(ListMonitorsResponse.getter(ListMonitorsResponse::monitors)).setter(ListMonitorsResponse.setter(Builder::monitors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Monitor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMonitorsResponse.getter(ListMonitorsResponse::nextToken)).setter(ListMonitorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMonitorsResponse.memberNameToFieldInitializer();
    private final List<Monitor> monitors;
    private final String nextToken;

    private ListMonitorsResponse(BuilderImpl builder) {
        super(builder);
        this.monitors = builder.monitors;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMonitors() {
        return this.monitors != null && !(this.monitors instanceof SdkAutoConstructList);
    }

    public final List<Monitor> monitors() {
        return this.monitors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMonitors() ? this.monitors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitorsResponse)) {
            return false;
        }
        ListMonitorsResponse other = (ListMonitorsResponse)((Object)obj);
        return this.hasMonitors() == other.hasMonitors() && Objects.equals(this.monitors(), other.monitors()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMonitorsResponse").add("Monitors", this.hasMonitors() ? this.monitors() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Monitors": {
                return Optional.ofNullable(clazz.cast(this.monitors()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Monitors", MONITORS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMonitorsResponse, T> g) {
        return obj -> g.apply((ListMonitorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InternetMonitorResponse.BuilderImpl
    implements Builder {
        private List<Monitor> monitors = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitorsResponse model) {
            super(model);
            this.monitors(model.monitors);
            this.nextToken(model.nextToken);
        }

        public final List<Monitor.Builder> getMonitors() {
            List<Monitor.Builder> result = MonitorListCopier.copyToBuilder(this.monitors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitors(Collection<Monitor.BuilderImpl> monitors) {
            this.monitors = MonitorListCopier.copyFromBuilder(monitors);
        }

        @Override
        public final Builder monitors(Collection<Monitor> monitors) {
            this.monitors = MonitorListCopier.copy(monitors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitors(Monitor ... monitors) {
            this.monitors(Arrays.asList(monitors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitors(Consumer<Monitor.Builder> ... monitors) {
            this.monitors(Stream.of(monitors).map(c -> (Monitor)((Monitor.Builder)Monitor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMonitorsResponse build() {
            return new ListMonitorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends InternetMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMonitorsResponse> {
        public Builder monitors(Collection<Monitor> var1);

        public Builder monitors(Monitor ... var1);

        public Builder monitors(Consumer<Monitor.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

