/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MonitorConfigState {
    PENDING("PENDING"),
    ACTIVE("ACTIVE"),
    INACTIVE("INACTIVE"),
    ERROR("ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MonitorConfigState> VALUE_MAP;
    private final String value;

    private MonitorConfigState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MonitorConfigState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MonitorConfigState> knownValues() {
        EnumSet<MonitorConfigState> knownValues = EnumSet.allOf(MonitorConfigState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MonitorConfigState.class, MonitorConfigState::toString);
    }
}

