/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.internetmonitor.model.InternetMeasurementsLogDelivery;
import software.amazon.awssdk.services.internetmonitor.model.InternetMonitorResponse;
import software.amazon.awssdk.services.internetmonitor.model.MonitorConfigState;
import software.amazon.awssdk.services.internetmonitor.model.MonitorProcessingStatusCode;
import software.amazon.awssdk.services.internetmonitor.model.SetOfARNsCopier;
import software.amazon.awssdk.services.internetmonitor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMonitorResponse
extends InternetMonitorResponse
implements ToCopyableBuilder<Builder, GetMonitorResponse> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorName").getter(GetMonitorResponse.getter(GetMonitorResponse::monitorName)).setter(GetMonitorResponse.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorName").build()}).build();
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorArn").getter(GetMonitorResponse.getter(GetMonitorResponse::monitorArn)).setter(GetMonitorResponse.setter(Builder::monitorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()}).build();
    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(GetMonitorResponse.getter(GetMonitorResponse::resources)).setter(GetMonitorResponse.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetMonitorResponse.getter(GetMonitorResponse::statusAsString)).setter(GetMonitorResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetMonitorResponse.getter(GetMonitorResponse::createdAt)).setter(GetMonitorResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(GetMonitorResponse.getter(GetMonitorResponse::modifiedAt)).setter(GetMonitorResponse.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PROCESSING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcessingStatus").getter(GetMonitorResponse.getter(GetMonitorResponse::processingStatusAsString)).setter(GetMonitorResponse.setter(Builder::processingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingStatus").build()}).build();
    private static final SdkField<String> PROCESSING_STATUS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcessingStatusInfo").getter(GetMonitorResponse.getter(GetMonitorResponse::processingStatusInfo)).setter(GetMonitorResponse.setter(Builder::processingStatusInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingStatusInfo").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetMonitorResponse.getter(GetMonitorResponse::tags)).setter(GetMonitorResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_CITY_NETWORKS_TO_MONITOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCityNetworksToMonitor").getter(GetMonitorResponse.getter(GetMonitorResponse::maxCityNetworksToMonitor)).setter(GetMonitorResponse.setter(Builder::maxCityNetworksToMonitor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCityNetworksToMonitor").build()}).build();
    private static final SdkField<InternetMeasurementsLogDelivery> INTERNET_MEASUREMENTS_LOG_DELIVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InternetMeasurementsLogDelivery").getter(GetMonitorResponse.getter(GetMonitorResponse::internetMeasurementsLogDelivery)).setter(GetMonitorResponse.setter(Builder::internetMeasurementsLogDelivery)).constructor(InternetMeasurementsLogDelivery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetMeasurementsLogDelivery").build()}).build();
    private static final SdkField<Integer> TRAFFIC_PERCENTAGE_TO_MONITOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TrafficPercentageToMonitor").getter(GetMonitorResponse.getter(GetMonitorResponse::trafficPercentageToMonitor)).setter(GetMonitorResponse.setter(Builder::trafficPercentageToMonitor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPercentageToMonitor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD, MONITOR_ARN_FIELD, RESOURCES_FIELD, STATUS_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, PROCESSING_STATUS_FIELD, PROCESSING_STATUS_INFO_FIELD, TAGS_FIELD, MAX_CITY_NETWORKS_TO_MONITOR_FIELD, INTERNET_MEASUREMENTS_LOG_DELIVERY_FIELD, TRAFFIC_PERCENTAGE_TO_MONITOR_FIELD));
    private final String monitorName;
    private final String monitorArn;
    private final List<String> resources;
    private final String status;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final String processingStatus;
    private final String processingStatusInfo;
    private final Map<String, String> tags;
    private final Integer maxCityNetworksToMonitor;
    private final InternetMeasurementsLogDelivery internetMeasurementsLogDelivery;
    private final Integer trafficPercentageToMonitor;

    private GetMonitorResponse(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.monitorArn = builder.monitorArn;
        this.resources = builder.resources;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.processingStatus = builder.processingStatus;
        this.processingStatusInfo = builder.processingStatusInfo;
        this.tags = builder.tags;
        this.maxCityNetworksToMonitor = builder.maxCityNetworksToMonitor;
        this.internetMeasurementsLogDelivery = builder.internetMeasurementsLogDelivery;
        this.trafficPercentageToMonitor = builder.trafficPercentageToMonitor;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final String monitorArn() {
        return this.monitorArn;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<String> resources() {
        return this.resources;
    }

    public final MonitorConfigState status() {
        return MonitorConfigState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final MonitorProcessingStatusCode processingStatus() {
        return MonitorProcessingStatusCode.fromValue(this.processingStatus);
    }

    public final String processingStatusAsString() {
        return this.processingStatus;
    }

    public final String processingStatusInfo() {
        return this.processingStatusInfo;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Integer maxCityNetworksToMonitor() {
        return this.maxCityNetworksToMonitor;
    }

    public final InternetMeasurementsLogDelivery internetMeasurementsLogDelivery() {
        return this.internetMeasurementsLogDelivery;
    }

    public final Integer trafficPercentageToMonitor() {
        return this.trafficPercentageToMonitor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingStatusInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCityNetworksToMonitor());
        hashCode = 31 * hashCode + Objects.hashCode(this.internetMeasurementsLogDelivery());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPercentageToMonitor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMonitorResponse)) {
            return false;
        }
        GetMonitorResponse other = (GetMonitorResponse)((Object)obj);
        return Objects.equals(this.monitorName(), other.monitorName()) && Objects.equals(this.monitorArn(), other.monitorArn()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.processingStatusAsString(), other.processingStatusAsString()) && Objects.equals(this.processingStatusInfo(), other.processingStatusInfo()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.maxCityNetworksToMonitor(), other.maxCityNetworksToMonitor()) && Objects.equals(this.internetMeasurementsLogDelivery(), other.internetMeasurementsLogDelivery()) && Objects.equals(this.trafficPercentageToMonitor(), other.trafficPercentageToMonitor());
    }

    public final String toString() {
        return ToString.builder((String)"GetMonitorResponse").add("MonitorName", (Object)this.monitorName()).add("MonitorArn", (Object)this.monitorArn()).add("Resources", this.hasResources() ? this.resources() : null).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("ProcessingStatus", (Object)this.processingStatusAsString()).add("ProcessingStatusInfo", (Object)this.processingStatusInfo()).add("Tags", this.hasTags() ? this.tags() : null).add("MaxCityNetworksToMonitor", (Object)this.maxCityNetworksToMonitor()).add("InternetMeasurementsLogDelivery", (Object)this.internetMeasurementsLogDelivery()).add("TrafficPercentageToMonitor", (Object)this.trafficPercentageToMonitor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "MonitorArn": {
                return Optional.ofNullable(clazz.cast(this.monitorArn()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "ProcessingStatus": {
                return Optional.ofNullable(clazz.cast(this.processingStatusAsString()));
            }
            case "ProcessingStatusInfo": {
                return Optional.ofNullable(clazz.cast(this.processingStatusInfo()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "MaxCityNetworksToMonitor": {
                return Optional.ofNullable(clazz.cast(this.maxCityNetworksToMonitor()));
            }
            case "InternetMeasurementsLogDelivery": {
                return Optional.ofNullable(clazz.cast(this.internetMeasurementsLogDelivery()));
            }
            case "TrafficPercentageToMonitor": {
                return Optional.ofNullable(clazz.cast(this.trafficPercentageToMonitor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMonitorResponse, T> g) {
        return obj -> g.apply((GetMonitorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InternetMonitorResponse.BuilderImpl
    implements Builder {
        private String monitorName;
        private String monitorArn;
        private List<String> resources = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Instant createdAt;
        private Instant modifiedAt;
        private String processingStatus;
        private String processingStatusInfo;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Integer maxCityNetworksToMonitor;
        private InternetMeasurementsLogDelivery internetMeasurementsLogDelivery;
        private Integer trafficPercentageToMonitor;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMonitorResponse model) {
            super(model);
            this.monitorName(model.monitorName);
            this.monitorArn(model.monitorArn);
            this.resources(model.resources);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.processingStatus(model.processingStatus);
            this.processingStatusInfo(model.processingStatusInfo);
            this.tags(model.tags);
            this.maxCityNetworksToMonitor(model.maxCityNetworksToMonitor);
            this.internetMeasurementsLogDelivery(model.internetMeasurementsLogDelivery);
            this.trafficPercentageToMonitor(model.trafficPercentageToMonitor);
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getMonitorArn() {
            return this.monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final Collection<String> getResources() {
            if (this.resources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = SetOfARNsCopier.copy(resources);
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = SetOfARNsCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MonitorConfigState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getProcessingStatus() {
            return this.processingStatus;
        }

        public final void setProcessingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
        }

        @Override
        public final Builder processingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
            return this;
        }

        @Override
        public final Builder processingStatus(MonitorProcessingStatusCode processingStatus) {
            this.processingStatus(processingStatus == null ? null : processingStatus.toString());
            return this;
        }

        public final String getProcessingStatusInfo() {
            return this.processingStatusInfo;
        }

        public final void setProcessingStatusInfo(String processingStatusInfo) {
            this.processingStatusInfo = processingStatusInfo;
        }

        @Override
        public final Builder processingStatusInfo(String processingStatusInfo) {
            this.processingStatusInfo = processingStatusInfo;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Integer getMaxCityNetworksToMonitor() {
            return this.maxCityNetworksToMonitor;
        }

        public final void setMaxCityNetworksToMonitor(Integer maxCityNetworksToMonitor) {
            this.maxCityNetworksToMonitor = maxCityNetworksToMonitor;
        }

        @Override
        public final Builder maxCityNetworksToMonitor(Integer maxCityNetworksToMonitor) {
            this.maxCityNetworksToMonitor = maxCityNetworksToMonitor;
            return this;
        }

        public final InternetMeasurementsLogDelivery.Builder getInternetMeasurementsLogDelivery() {
            return this.internetMeasurementsLogDelivery != null ? this.internetMeasurementsLogDelivery.toBuilder() : null;
        }

        public final void setInternetMeasurementsLogDelivery(InternetMeasurementsLogDelivery.BuilderImpl internetMeasurementsLogDelivery) {
            this.internetMeasurementsLogDelivery = internetMeasurementsLogDelivery != null ? internetMeasurementsLogDelivery.build() : null;
        }

        @Override
        public final Builder internetMeasurementsLogDelivery(InternetMeasurementsLogDelivery internetMeasurementsLogDelivery) {
            this.internetMeasurementsLogDelivery = internetMeasurementsLogDelivery;
            return this;
        }

        public final Integer getTrafficPercentageToMonitor() {
            return this.trafficPercentageToMonitor;
        }

        public final void setTrafficPercentageToMonitor(Integer trafficPercentageToMonitor) {
            this.trafficPercentageToMonitor = trafficPercentageToMonitor;
        }

        @Override
        public final Builder trafficPercentageToMonitor(Integer trafficPercentageToMonitor) {
            this.trafficPercentageToMonitor = trafficPercentageToMonitor;
            return this;
        }

        @Override
        public GetMonitorResponse build() {
            return new GetMonitorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InternetMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMonitorResponse> {
        public Builder monitorName(String var1);

        public Builder monitorArn(String var1);

        public Builder resources(Collection<String> var1);

        public Builder resources(String ... var1);

        public Builder status(String var1);

        public Builder status(MonitorConfigState var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder processingStatus(String var1);

        public Builder processingStatus(MonitorProcessingStatusCode var1);

        public Builder processingStatusInfo(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder maxCityNetworksToMonitor(Integer var1);

        public Builder internetMeasurementsLogDelivery(InternetMeasurementsLogDelivery var1);

        default public Builder internetMeasurementsLogDelivery(Consumer<InternetMeasurementsLogDelivery.Builder> internetMeasurementsLogDelivery) {
            return this.internetMeasurementsLogDelivery((InternetMeasurementsLogDelivery)((InternetMeasurementsLogDelivery.Builder)InternetMeasurementsLogDelivery.builder().applyMutation(internetMeasurementsLogDelivery)).build());
        }

        public Builder trafficPercentageToMonitor(Integer var1);
    }
}

