/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.internetmonitor.model.InternetMeasurementsLogDelivery;
import software.amazon.awssdk.services.internetmonitor.model.InternetMonitorRequest;
import software.amazon.awssdk.services.internetmonitor.model.MonitorConfigState;
import software.amazon.awssdk.services.internetmonitor.model.SetOfARNsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMonitorRequest
extends InternetMonitorRequest
implements ToCopyableBuilder<Builder, UpdateMonitorRequest> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorName").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::monitorName)).setter(UpdateMonitorRequest.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MonitorName").build()}).build();
    private static final SdkField<List<String>> RESOURCES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourcesToAdd").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::resourcesToAdd)).setter(UpdateMonitorRequest.setter(Builder::resourcesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourcesToRemove").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::resourcesToRemove)).setter(UpdateMonitorRequest.setter(Builder::resourcesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::statusAsString)).setter(UpdateMonitorRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::clientToken)).setter(UpdateMonitorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Integer> MAX_CITY_NETWORKS_TO_MONITOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCityNetworksToMonitor").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::maxCityNetworksToMonitor)).setter(UpdateMonitorRequest.setter(Builder::maxCityNetworksToMonitor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCityNetworksToMonitor").build()}).build();
    private static final SdkField<InternetMeasurementsLogDelivery> INTERNET_MEASUREMENTS_LOG_DELIVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InternetMeasurementsLogDelivery").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::internetMeasurementsLogDelivery)).setter(UpdateMonitorRequest.setter(Builder::internetMeasurementsLogDelivery)).constructor(InternetMeasurementsLogDelivery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetMeasurementsLogDelivery").build()}).build();
    private static final SdkField<Integer> TRAFFIC_PERCENTAGE_TO_MONITOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TrafficPercentageToMonitor").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::trafficPercentageToMonitor)).setter(UpdateMonitorRequest.setter(Builder::trafficPercentageToMonitor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPercentageToMonitor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD, RESOURCES_TO_ADD_FIELD, RESOURCES_TO_REMOVE_FIELD, STATUS_FIELD, CLIENT_TOKEN_FIELD, MAX_CITY_NETWORKS_TO_MONITOR_FIELD, INTERNET_MEASUREMENTS_LOG_DELIVERY_FIELD, TRAFFIC_PERCENTAGE_TO_MONITOR_FIELD));
    private final String monitorName;
    private final List<String> resourcesToAdd;
    private final List<String> resourcesToRemove;
    private final String status;
    private final String clientToken;
    private final Integer maxCityNetworksToMonitor;
    private final InternetMeasurementsLogDelivery internetMeasurementsLogDelivery;
    private final Integer trafficPercentageToMonitor;

    private UpdateMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.resourcesToAdd = builder.resourcesToAdd;
        this.resourcesToRemove = builder.resourcesToRemove;
        this.status = builder.status;
        this.clientToken = builder.clientToken;
        this.maxCityNetworksToMonitor = builder.maxCityNetworksToMonitor;
        this.internetMeasurementsLogDelivery = builder.internetMeasurementsLogDelivery;
        this.trafficPercentageToMonitor = builder.trafficPercentageToMonitor;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final boolean hasResourcesToAdd() {
        return this.resourcesToAdd != null && !(this.resourcesToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> resourcesToAdd() {
        return this.resourcesToAdd;
    }

    public final boolean hasResourcesToRemove() {
        return this.resourcesToRemove != null && !(this.resourcesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> resourcesToRemove() {
        return this.resourcesToRemove;
    }

    public final MonitorConfigState status() {
        return MonitorConfigState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Integer maxCityNetworksToMonitor() {
        return this.maxCityNetworksToMonitor;
    }

    public final InternetMeasurementsLogDelivery internetMeasurementsLogDelivery() {
        return this.internetMeasurementsLogDelivery;
    }

    public final Integer trafficPercentageToMonitor() {
        return this.trafficPercentageToMonitor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourcesToAdd() ? this.resourcesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourcesToRemove() ? this.resourcesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCityNetworksToMonitor());
        hashCode = 31 * hashCode + Objects.hashCode(this.internetMeasurementsLogDelivery());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPercentageToMonitor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMonitorRequest)) {
            return false;
        }
        UpdateMonitorRequest other = (UpdateMonitorRequest)((Object)obj);
        return Objects.equals(this.monitorName(), other.monitorName()) && this.hasResourcesToAdd() == other.hasResourcesToAdd() && Objects.equals(this.resourcesToAdd(), other.resourcesToAdd()) && this.hasResourcesToRemove() == other.hasResourcesToRemove() && Objects.equals(this.resourcesToRemove(), other.resourcesToRemove()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.maxCityNetworksToMonitor(), other.maxCityNetworksToMonitor()) && Objects.equals(this.internetMeasurementsLogDelivery(), other.internetMeasurementsLogDelivery()) && Objects.equals(this.trafficPercentageToMonitor(), other.trafficPercentageToMonitor());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMonitorRequest").add("MonitorName", (Object)this.monitorName()).add("ResourcesToAdd", this.hasResourcesToAdd() ? this.resourcesToAdd() : null).add("ResourcesToRemove", this.hasResourcesToRemove() ? this.resourcesToRemove() : null).add("Status", (Object)this.statusAsString()).add("ClientToken", (Object)this.clientToken()).add("MaxCityNetworksToMonitor", (Object)this.maxCityNetworksToMonitor()).add("InternetMeasurementsLogDelivery", (Object)this.internetMeasurementsLogDelivery()).add("TrafficPercentageToMonitor", (Object)this.trafficPercentageToMonitor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "ResourcesToAdd": {
                return Optional.ofNullable(clazz.cast(this.resourcesToAdd()));
            }
            case "ResourcesToRemove": {
                return Optional.ofNullable(clazz.cast(this.resourcesToRemove()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "MaxCityNetworksToMonitor": {
                return Optional.ofNullable(clazz.cast(this.maxCityNetworksToMonitor()));
            }
            case "InternetMeasurementsLogDelivery": {
                return Optional.ofNullable(clazz.cast(this.internetMeasurementsLogDelivery()));
            }
            case "TrafficPercentageToMonitor": {
                return Optional.ofNullable(clazz.cast(this.trafficPercentageToMonitor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMonitorRequest, T> g) {
        return obj -> g.apply((UpdateMonitorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InternetMonitorRequest.BuilderImpl
    implements Builder {
        private String monitorName;
        private List<String> resourcesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourcesToRemove = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String clientToken;
        private Integer maxCityNetworksToMonitor;
        private InternetMeasurementsLogDelivery internetMeasurementsLogDelivery;
        private Integer trafficPercentageToMonitor;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMonitorRequest model) {
            super(model);
            this.monitorName(model.monitorName);
            this.resourcesToAdd(model.resourcesToAdd);
            this.resourcesToRemove(model.resourcesToRemove);
            this.status(model.status);
            this.clientToken(model.clientToken);
            this.maxCityNetworksToMonitor(model.maxCityNetworksToMonitor);
            this.internetMeasurementsLogDelivery(model.internetMeasurementsLogDelivery);
            this.trafficPercentageToMonitor(model.trafficPercentageToMonitor);
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final Collection<String> getResourcesToAdd() {
            if (this.resourcesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourcesToAdd;
        }

        public final void setResourcesToAdd(Collection<String> resourcesToAdd) {
            this.resourcesToAdd = SetOfARNsCopier.copy(resourcesToAdd);
        }

        @Override
        public final Builder resourcesToAdd(Collection<String> resourcesToAdd) {
            this.resourcesToAdd = SetOfARNsCopier.copy(resourcesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToAdd(String ... resourcesToAdd) {
            this.resourcesToAdd(Arrays.asList(resourcesToAdd));
            return this;
        }

        public final Collection<String> getResourcesToRemove() {
            if (this.resourcesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourcesToRemove;
        }

        public final void setResourcesToRemove(Collection<String> resourcesToRemove) {
            this.resourcesToRemove = SetOfARNsCopier.copy(resourcesToRemove);
        }

        @Override
        public final Builder resourcesToRemove(Collection<String> resourcesToRemove) {
            this.resourcesToRemove = SetOfARNsCopier.copy(resourcesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToRemove(String ... resourcesToRemove) {
            this.resourcesToRemove(Arrays.asList(resourcesToRemove));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MonitorConfigState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Integer getMaxCityNetworksToMonitor() {
            return this.maxCityNetworksToMonitor;
        }

        public final void setMaxCityNetworksToMonitor(Integer maxCityNetworksToMonitor) {
            this.maxCityNetworksToMonitor = maxCityNetworksToMonitor;
        }

        @Override
        public final Builder maxCityNetworksToMonitor(Integer maxCityNetworksToMonitor) {
            this.maxCityNetworksToMonitor = maxCityNetworksToMonitor;
            return this;
        }

        public final InternetMeasurementsLogDelivery.Builder getInternetMeasurementsLogDelivery() {
            return this.internetMeasurementsLogDelivery != null ? this.internetMeasurementsLogDelivery.toBuilder() : null;
        }

        public final void setInternetMeasurementsLogDelivery(InternetMeasurementsLogDelivery.BuilderImpl internetMeasurementsLogDelivery) {
            this.internetMeasurementsLogDelivery = internetMeasurementsLogDelivery != null ? internetMeasurementsLogDelivery.build() : null;
        }

        @Override
        public final Builder internetMeasurementsLogDelivery(InternetMeasurementsLogDelivery internetMeasurementsLogDelivery) {
            this.internetMeasurementsLogDelivery = internetMeasurementsLogDelivery;
            return this;
        }

        public final Integer getTrafficPercentageToMonitor() {
            return this.trafficPercentageToMonitor;
        }

        public final void setTrafficPercentageToMonitor(Integer trafficPercentageToMonitor) {
            this.trafficPercentageToMonitor = trafficPercentageToMonitor;
        }

        @Override
        public final Builder trafficPercentageToMonitor(Integer trafficPercentageToMonitor) {
            this.trafficPercentageToMonitor = trafficPercentageToMonitor;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMonitorRequest build() {
            return new UpdateMonitorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InternetMonitorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMonitorRequest> {
        public Builder monitorName(String var1);

        public Builder resourcesToAdd(Collection<String> var1);

        public Builder resourcesToAdd(String ... var1);

        public Builder resourcesToRemove(Collection<String> var1);

        public Builder resourcesToRemove(String ... var1);

        public Builder status(String var1);

        public Builder status(MonitorConfigState var1);

        public Builder clientToken(String var1);

        public Builder maxCityNetworksToMonitor(Integer var1);

        public Builder internetMeasurementsLogDelivery(InternetMeasurementsLogDelivery var1);

        default public Builder internetMeasurementsLogDelivery(Consumer<InternetMeasurementsLogDelivery.Builder> internetMeasurementsLogDelivery) {
            return this.internetMeasurementsLogDelivery((InternetMeasurementsLogDelivery)((InternetMeasurementsLogDelivery.Builder)InternetMeasurementsLogDelivery.builder().applyMutation(internetMeasurementsLogDelivery)).build());
        }

        public Builder trafficPercentageToMonitor(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

