/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspectorscan.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspectorscan.model.InspectorScanRequest;
import software.amazon.awssdk.services.inspectorscan.model.OutputFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanSbomRequest
extends InspectorScanRequest
implements ToCopyableBuilder<Builder, ScanSbomRequest> {
    private static final SdkField<Document> SBOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("sbom").getter(ScanSbomRequest.getter(ScanSbomRequest::sbom)).setter(ScanSbomRequest.setter(Builder::sbom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sbom").build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputFormat").getter(ScanSbomRequest.getter(ScanSbomRequest::outputFormatAsString)).setter(ScanSbomRequest.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SBOM_FIELD, OUTPUT_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("sbom", SBOM_FIELD);
            this.put("outputFormat", OUTPUT_FORMAT_FIELD);
        }
    });
    private final Document sbom;
    private final String outputFormat;

    private ScanSbomRequest(BuilderImpl builder) {
        super(builder);
        this.sbom = builder.sbom;
        this.outputFormat = builder.outputFormat;
    }

    public final Document sbom() {
        return this.sbom;
    }

    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sbom());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanSbomRequest)) {
            return false;
        }
        ScanSbomRequest other = (ScanSbomRequest)((Object)obj);
        return Objects.equals(this.sbom(), other.sbom()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ScanSbomRequest").add("Sbom", (Object)this.sbom()).add("OutputFormat", (Object)this.outputFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sbom": {
                return Optional.ofNullable(clazz.cast(this.sbom()));
            }
            case "outputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScanSbomRequest, T> g) {
        return obj -> g.apply((ScanSbomRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorScanRequest.BuilderImpl
    implements Builder {
        private Document sbom;
        private String outputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanSbomRequest model) {
            super(model);
            this.sbom(model.sbom);
            this.outputFormat(model.outputFormat);
        }

        public final Document getSbom() {
            return this.sbom;
        }

        public final void setSbom(Document sbom) {
            this.sbom = sbom;
        }

        @Override
        public final Builder sbom(Document sbom) {
            this.sbom = sbom;
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ScanSbomRequest build() {
            return new ScanSbomRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends InspectorScanRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ScanSbomRequest> {
        public Builder sbom(Document var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(OutputFormat var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

