/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2AsyncClient;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.Counts;
import software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest;
import software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse;

public class ListCoverageStatisticsPublisher
implements SdkPublisher<ListCoverageStatisticsResponse> {
    private final Inspector2AsyncClient client;
    private final ListCoverageStatisticsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCoverageStatisticsPublisher(Inspector2AsyncClient client, ListCoverageStatisticsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCoverageStatisticsPublisher(Inspector2AsyncClient client, ListCoverageStatisticsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCoverageStatisticsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCoverageStatisticsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Counts> countsByGroup() {
        Function<ListCoverageStatisticsResponse, Iterator> getIterator = response -> {
            if (response != null && response.countsByGroup() != null) {
                return response.countsByGroup().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCoverageStatisticsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCoverageStatisticsResponseFetcher
    implements AsyncPageFetcher<ListCoverageStatisticsResponse> {
        private ListCoverageStatisticsResponseFetcher() {
        }

        public boolean hasNextPage(ListCoverageStatisticsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCoverageStatisticsResponse> nextPage(ListCoverageStatisticsResponse previousPage) {
            if (previousPage == null) {
                return ListCoverageStatisticsPublisher.this.client.listCoverageStatistics(ListCoverageStatisticsPublisher.this.firstRequest);
            }
            return ListCoverageStatisticsPublisher.this.client.listCoverageStatistics((ListCoverageStatisticsRequest)((Object)ListCoverageStatisticsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

