/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector2.model.DailySchedule;
import software.amazon.awssdk.services.inspector2.model.MonthlySchedule;
import software.amazon.awssdk.services.inspector2.model.OneTimeSchedule;
import software.amazon.awssdk.services.inspector2.model.WeeklySchedule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Schedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Schedule> {
    private static final SdkField<OneTimeSchedule> ONE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oneTime").getter(Schedule.getter(Schedule::oneTime)).setter(Schedule.setter(Builder::oneTime)).constructor(OneTimeSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oneTime").build()}).build();
    private static final SdkField<DailySchedule> DAILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("daily").getter(Schedule.getter(Schedule::daily)).setter(Schedule.setter(Builder::daily)).constructor(DailySchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("daily").build()}).build();
    private static final SdkField<WeeklySchedule> WEEKLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("weekly").getter(Schedule.getter(Schedule::weekly)).setter(Schedule.setter(Builder::weekly)).constructor(WeeklySchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weekly").build()}).build();
    private static final SdkField<MonthlySchedule> MONTHLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("monthly").getter(Schedule.getter(Schedule::monthly)).setter(Schedule.setter(Builder::monthly)).constructor(MonthlySchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthly").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ONE_TIME_FIELD, DAILY_FIELD, WEEKLY_FIELD, MONTHLY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Schedule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final OneTimeSchedule oneTime;
    private final DailySchedule daily;
    private final WeeklySchedule weekly;
    private final MonthlySchedule monthly;
    private final Type type;

    private Schedule(BuilderImpl builder) {
        this.oneTime = builder.oneTime;
        this.daily = builder.daily;
        this.weekly = builder.weekly;
        this.monthly = builder.monthly;
        this.type = builder.type;
    }

    public final OneTimeSchedule oneTime() {
        return this.oneTime;
    }

    public final DailySchedule daily() {
        return this.daily;
    }

    public final WeeklySchedule weekly() {
        return this.weekly;
    }

    public final MonthlySchedule monthly() {
        return this.monthly;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.oneTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.daily());
        hashCode = 31 * hashCode + Objects.hashCode(this.weekly());
        hashCode = 31 * hashCode + Objects.hashCode(this.monthly());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)obj;
        return Objects.equals(this.oneTime(), other.oneTime()) && Objects.equals(this.daily(), other.daily()) && Objects.equals(this.weekly(), other.weekly()) && Objects.equals(this.monthly(), other.monthly());
    }

    public final String toString() {
        return ToString.builder((String)"Schedule").add("OneTime", (Object)this.oneTime()).add("Daily", (Object)this.daily()).add("Weekly", (Object)this.weekly()).add("Monthly", (Object)this.monthly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "oneTime": {
                return Optional.ofNullable(clazz.cast(this.oneTime()));
            }
            case "daily": {
                return Optional.ofNullable(clazz.cast(this.daily()));
            }
            case "weekly": {
                return Optional.ofNullable(clazz.cast(this.weekly()));
            }
            case "monthly": {
                return Optional.ofNullable(clazz.cast(this.monthly()));
            }
        }
        return Optional.empty();
    }

    public static Schedule fromOneTime(OneTimeSchedule oneTime) {
        return (Schedule)Schedule.builder().oneTime(oneTime).build();
    }

    public static Schedule fromOneTime(Consumer<OneTimeSchedule.Builder> oneTime) {
        OneTimeSchedule.Builder builder = OneTimeSchedule.builder();
        oneTime.accept(builder);
        return Schedule.fromOneTime((OneTimeSchedule)builder.build());
    }

    public static Schedule fromDaily(DailySchedule daily) {
        return (Schedule)Schedule.builder().daily(daily).build();
    }

    public static Schedule fromDaily(Consumer<DailySchedule.Builder> daily) {
        DailySchedule.Builder builder = DailySchedule.builder();
        daily.accept(builder);
        return Schedule.fromDaily((DailySchedule)builder.build());
    }

    public static Schedule fromWeekly(WeeklySchedule weekly) {
        return (Schedule)Schedule.builder().weekly(weekly).build();
    }

    public static Schedule fromWeekly(Consumer<WeeklySchedule.Builder> weekly) {
        WeeklySchedule.Builder builder = WeeklySchedule.builder();
        weekly.accept(builder);
        return Schedule.fromWeekly((WeeklySchedule)builder.build());
    }

    public static Schedule fromMonthly(MonthlySchedule monthly) {
        return (Schedule)Schedule.builder().monthly(monthly).build();
    }

    public static Schedule fromMonthly(Consumer<MonthlySchedule.Builder> monthly) {
        MonthlySchedule.Builder builder = MonthlySchedule.builder();
        monthly.accept(builder);
        return Schedule.fromMonthly((MonthlySchedule)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("oneTime", ONE_TIME_FIELD);
        map.put("daily", DAILY_FIELD);
        map.put("weekly", WEEKLY_FIELD);
        map.put("monthly", MONTHLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Schedule, T> g) {
        return obj -> g.apply((Schedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ONE_TIME,
        DAILY,
        WEEKLY,
        MONTHLY,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private OneTimeSchedule oneTime;
        private DailySchedule daily;
        private WeeklySchedule weekly;
        private MonthlySchedule monthly;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            this.oneTime(model.oneTime);
            this.daily(model.daily);
            this.weekly(model.weekly);
            this.monthly(model.monthly);
        }

        public final OneTimeSchedule.Builder getOneTime() {
            return this.oneTime != null ? this.oneTime.toBuilder() : null;
        }

        public final void setOneTime(OneTimeSchedule.BuilderImpl oneTime) {
            OneTimeSchedule oldValue = this.oneTime;
            this.oneTime = oneTime != null ? oneTime.build() : null;
            this.handleUnionValueChange(Type.ONE_TIME, oldValue, this.oneTime);
        }

        @Override
        public final Builder oneTime(OneTimeSchedule oneTime) {
            OneTimeSchedule oldValue = this.oneTime;
            this.oneTime = oneTime;
            this.handleUnionValueChange(Type.ONE_TIME, oldValue, this.oneTime);
            return this;
        }

        public final DailySchedule.Builder getDaily() {
            return this.daily != null ? this.daily.toBuilder() : null;
        }

        public final void setDaily(DailySchedule.BuilderImpl daily) {
            DailySchedule oldValue = this.daily;
            this.daily = daily != null ? daily.build() : null;
            this.handleUnionValueChange(Type.DAILY, oldValue, this.daily);
        }

        @Override
        public final Builder daily(DailySchedule daily) {
            DailySchedule oldValue = this.daily;
            this.daily = daily;
            this.handleUnionValueChange(Type.DAILY, oldValue, this.daily);
            return this;
        }

        public final WeeklySchedule.Builder getWeekly() {
            return this.weekly != null ? this.weekly.toBuilder() : null;
        }

        public final void setWeekly(WeeklySchedule.BuilderImpl weekly) {
            WeeklySchedule oldValue = this.weekly;
            this.weekly = weekly != null ? weekly.build() : null;
            this.handleUnionValueChange(Type.WEEKLY, oldValue, this.weekly);
        }

        @Override
        public final Builder weekly(WeeklySchedule weekly) {
            WeeklySchedule oldValue = this.weekly;
            this.weekly = weekly;
            this.handleUnionValueChange(Type.WEEKLY, oldValue, this.weekly);
            return this;
        }

        public final MonthlySchedule.Builder getMonthly() {
            return this.monthly != null ? this.monthly.toBuilder() : null;
        }

        public final void setMonthly(MonthlySchedule.BuilderImpl monthly) {
            MonthlySchedule oldValue = this.monthly;
            this.monthly = monthly != null ? monthly.build() : null;
            this.handleUnionValueChange(Type.MONTHLY, oldValue, this.monthly);
        }

        @Override
        public final Builder monthly(MonthlySchedule monthly) {
            MonthlySchedule oldValue = this.monthly;
            this.monthly = monthly;
            this.handleUnionValueChange(Type.MONTHLY, oldValue, this.monthly);
            return this;
        }

        public Schedule build() {
            return new Schedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Schedule> {
        public Builder oneTime(OneTimeSchedule var1);

        default public Builder oneTime(Consumer<OneTimeSchedule.Builder> oneTime) {
            return this.oneTime((OneTimeSchedule)((OneTimeSchedule.Builder)OneTimeSchedule.builder().applyMutation(oneTime)).build());
        }

        public Builder daily(DailySchedule var1);

        default public Builder daily(Consumer<DailySchedule.Builder> daily) {
            return this.daily((DailySchedule)((DailySchedule.Builder)DailySchedule.builder().applyMutation(daily)).build());
        }

        public Builder weekly(WeeklySchedule var1);

        default public Builder weekly(Consumer<WeeklySchedule.Builder> weekly) {
            return this.weekly((WeeklySchedule)((WeeklySchedule.Builder)WeeklySchedule.builder().applyMutation(weekly)).build());
        }

        public Builder monthly(MonthlySchedule var1);

        default public Builder monthly(Consumer<MonthlySchedule.Builder> monthly) {
            return this.monthly((MonthlySchedule)((MonthlySchedule.Builder)MonthlySchedule.builder().applyMutation(monthly)).build());
        }
    }
}

