/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IntegrationStatus {
    PENDING("PENDING"),
    IN_PROGRESS("IN_PROGRESS"),
    ACTIVE("ACTIVE"),
    INACTIVE("INACTIVE"),
    DISABLING("DISABLING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IntegrationStatus> VALUE_MAP;
    private final String value;

    private IntegrationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IntegrationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IntegrationStatus> knownValues() {
        EnumSet<IntegrationStatus> knownValues = EnumSet.allOf(IntegrationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IntegrationStatus.class, IntegrationStatus::toString);
    }
}

