/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.CodeRepositoryProviderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeRepositoryDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeRepositoryDetails> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(CodeRepositoryDetails.getter(CodeRepositoryDetails::projectName)).setter(CodeRepositoryDetails.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationArn").getter(CodeRepositoryDetails.getter(CodeRepositoryDetails::integrationArn)).setter(CodeRepositoryDetails.setter(Builder::integrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationArn").build()}).build();
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerType").getter(CodeRepositoryDetails.getter(CodeRepositoryDetails::providerTypeAsString)).setter(CodeRepositoryDetails.setter(Builder::providerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD, INTEGRATION_ARN_FIELD, PROVIDER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeRepositoryDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String projectName;
    private final String integrationArn;
    private final String providerType;

    private CodeRepositoryDetails(BuilderImpl builder) {
        this.projectName = builder.projectName;
        this.integrationArn = builder.integrationArn;
        this.providerType = builder.providerType;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String integrationArn() {
        return this.integrationArn;
    }

    public final CodeRepositoryProviderType providerType() {
        return CodeRepositoryProviderType.fromValue(this.providerType);
    }

    public final String providerTypeAsString() {
        return this.providerType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepositoryDetails)) {
            return false;
        }
        CodeRepositoryDetails other = (CodeRepositoryDetails)obj;
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.integrationArn(), other.integrationArn()) && Objects.equals(this.providerTypeAsString(), other.providerTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CodeRepositoryDetails").add("ProjectName", (Object)this.projectName()).add("IntegrationArn", (Object)this.integrationArn()).add("ProviderType", (Object)this.providerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "integrationArn": {
                return Optional.ofNullable(clazz.cast(this.integrationArn()));
            }
            case "providerType": {
                return Optional.ofNullable(clazz.cast(this.providerTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("integrationArn", INTEGRATION_ARN_FIELD);
        map.put("providerType", PROVIDER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeRepositoryDetails, T> g) {
        return obj -> g.apply((CodeRepositoryDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectName;
        private String integrationArn;
        private String providerType;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepositoryDetails model) {
            this.projectName(model.projectName);
            this.integrationArn(model.integrationArn);
            this.providerType(model.providerType);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getIntegrationArn() {
            return this.integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final String getProviderType() {
            return this.providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(CodeRepositoryProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public CodeRepositoryDetails build() {
            return new CodeRepositoryDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeRepositoryDetails> {
        public Builder projectName(String var1);

        public Builder integrationArn(String var1);

        public Builder providerType(String var1);

        public Builder providerType(CodeRepositoryProviderType var1);
    }
}

