/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.CisFindingStatus;
import software.amazon.awssdk.services.inspector2.model.CisSecurityLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CisScanResultDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CisScanResultDetails> {
    private static final SdkField<String> SCAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanArn").getter(CisScanResultDetails.getter(CisScanResultDetails::scanArn)).setter(CisScanResultDetails.setter(Builder::scanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArn").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(CisScanResultDetails.getter(CisScanResultDetails::accountId)).setter(CisScanResultDetails.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> TARGET_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetResourceId").getter(CisScanResultDetails.getter(CisScanResultDetails::targetResourceId)).setter(CisScanResultDetails.setter(Builder::targetResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceId").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(CisScanResultDetails.getter(CisScanResultDetails::platform)).setter(CisScanResultDetails.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CisScanResultDetails.getter(CisScanResultDetails::statusAsString)).setter(CisScanResultDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(CisScanResultDetails.getter(CisScanResultDetails::statusReason)).setter(CisScanResultDetails.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> CHECK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checkId").getter(CisScanResultDetails.getter(CisScanResultDetails::checkId)).setter(CisScanResultDetails.setter(Builder::checkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(CisScanResultDetails.getter(CisScanResultDetails::title)).setter(CisScanResultDetails.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> CHECK_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checkDescription").getter(CisScanResultDetails.getter(CisScanResultDetails::checkDescription)).setter(CisScanResultDetails.setter(Builder::checkDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkDescription").build()}).build();
    private static final SdkField<String> REMEDIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remediation").getter(CisScanResultDetails.getter(CisScanResultDetails::remediation)).setter(CisScanResultDetails.setter(Builder::remediation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("level").getter(CisScanResultDetails.getter(CisScanResultDetails::levelAsString)).setter(CisScanResultDetails.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final SdkField<String> FINDING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingArn").getter(CisScanResultDetails.getter(CisScanResultDetails::findingArn)).setter(CisScanResultDetails.setter(Builder::findingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_ARN_FIELD, ACCOUNT_ID_FIELD, TARGET_RESOURCE_ID_FIELD, PLATFORM_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CHECK_ID_FIELD, TITLE_FIELD, CHECK_DESCRIPTION_FIELD, REMEDIATION_FIELD, LEVEL_FIELD, FINDING_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CisScanResultDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scanArn;
    private final String accountId;
    private final String targetResourceId;
    private final String platform;
    private final String status;
    private final String statusReason;
    private final String checkId;
    private final String title;
    private final String checkDescription;
    private final String remediation;
    private final String level;
    private final String findingArn;

    private CisScanResultDetails(BuilderImpl builder) {
        this.scanArn = builder.scanArn;
        this.accountId = builder.accountId;
        this.targetResourceId = builder.targetResourceId;
        this.platform = builder.platform;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.checkId = builder.checkId;
        this.title = builder.title;
        this.checkDescription = builder.checkDescription;
        this.remediation = builder.remediation;
        this.level = builder.level;
        this.findingArn = builder.findingArn;
    }

    public final String scanArn() {
        return this.scanArn;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String targetResourceId() {
        return this.targetResourceId;
    }

    public final String platform() {
        return this.platform;
    }

    public final CisFindingStatus status() {
        return CisFindingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String checkId() {
        return this.checkId;
    }

    public final String title() {
        return this.title;
    }

    public final String checkDescription() {
        return this.checkDescription;
    }

    public final String remediation() {
        return this.remediation;
    }

    public final CisSecurityLevel level() {
        return CisSecurityLevel.fromValue(this.level);
    }

    public final String levelAsString() {
        return this.level;
    }

    public final String findingArn() {
        return this.findingArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediation());
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisScanResultDetails)) {
            return false;
        }
        CisScanResultDetails other = (CisScanResultDetails)obj;
        return Objects.equals(this.scanArn(), other.scanArn()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.targetResourceId(), other.targetResourceId()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.checkId(), other.checkId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.checkDescription(), other.checkDescription()) && Objects.equals(this.remediation(), other.remediation()) && Objects.equals(this.levelAsString(), other.levelAsString()) && Objects.equals(this.findingArn(), other.findingArn());
    }

    public final String toString() {
        return ToString.builder((String)"CisScanResultDetails").add("ScanArn", (Object)this.scanArn()).add("AccountId", (Object)this.accountId()).add("TargetResourceId", (Object)this.targetResourceId()).add("Platform", (Object)this.platform()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("CheckId", (Object)this.checkId()).add("Title", (Object)this.title()).add("CheckDescription", (Object)this.checkDescription()).add("Remediation", (Object)this.remediation()).add("Level", (Object)this.levelAsString()).add("FindingArn", (Object)this.findingArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scanArn": {
                return Optional.ofNullable(clazz.cast(this.scanArn()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "targetResourceId": {
                return Optional.ofNullable(clazz.cast(this.targetResourceId()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "checkId": {
                return Optional.ofNullable(clazz.cast(this.checkId()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "checkDescription": {
                return Optional.ofNullable(clazz.cast(this.checkDescription()));
            }
            case "remediation": {
                return Optional.ofNullable(clazz.cast(this.remediation()));
            }
            case "level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
            case "findingArn": {
                return Optional.ofNullable(clazz.cast(this.findingArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("scanArn", SCAN_ARN_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("targetResourceId", TARGET_RESOURCE_ID_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("checkId", CHECK_ID_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("checkDescription", CHECK_DESCRIPTION_FIELD);
        map.put("remediation", REMEDIATION_FIELD);
        map.put("level", LEVEL_FIELD);
        map.put("findingArn", FINDING_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisScanResultDetails, T> g) {
        return obj -> g.apply((CisScanResultDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scanArn;
        private String accountId;
        private String targetResourceId;
        private String platform;
        private String status;
        private String statusReason;
        private String checkId;
        private String title;
        private String checkDescription;
        private String remediation;
        private String level;
        private String findingArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CisScanResultDetails model) {
            this.scanArn(model.scanArn);
            this.accountId(model.accountId);
            this.targetResourceId(model.targetResourceId);
            this.platform(model.platform);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.checkId(model.checkId);
            this.title(model.title);
            this.checkDescription(model.checkDescription);
            this.remediation(model.remediation);
            this.level(model.level);
            this.findingArn(model.findingArn);
        }

        public final String getScanArn() {
            return this.scanArn;
        }

        public final void setScanArn(String scanArn) {
            this.scanArn = scanArn;
        }

        @Override
        public final Builder scanArn(String scanArn) {
            this.scanArn = scanArn;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getTargetResourceId() {
            return this.targetResourceId;
        }

        public final void setTargetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
        }

        @Override
        public final Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CisFindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getCheckId() {
            return this.checkId;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getCheckDescription() {
            return this.checkDescription;
        }

        public final void setCheckDescription(String checkDescription) {
            this.checkDescription = checkDescription;
        }

        @Override
        public final Builder checkDescription(String checkDescription) {
            this.checkDescription = checkDescription;
            return this;
        }

        public final String getRemediation() {
            return this.remediation;
        }

        public final void setRemediation(String remediation) {
            this.remediation = remediation;
        }

        @Override
        public final Builder remediation(String remediation) {
            this.remediation = remediation;
            return this;
        }

        public final String getLevel() {
            return this.level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(CisSecurityLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getFindingArn() {
            return this.findingArn;
        }

        public final void setFindingArn(String findingArn) {
            this.findingArn = findingArn;
        }

        @Override
        public final Builder findingArn(String findingArn) {
            this.findingArn = findingArn;
            return this;
        }

        public CisScanResultDetails build() {
            return new CisScanResultDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CisScanResultDetails> {
        public Builder scanArn(String var1);

        public Builder accountId(String var1);

        public Builder targetResourceId(String var1);

        public Builder platform(String var1);

        public Builder status(String var1);

        public Builder status(CisFindingStatus var1);

        public Builder statusReason(String var1);

        public Builder checkId(String var1);

        public Builder title(String var1);

        public Builder checkDescription(String var1);

        public Builder remediation(String var1);

        public Builder level(String var1);

        public Builder level(CisSecurityLevel var1);

        public Builder findingArn(String var1);
    }
}

