/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.AwsEksWorkloadInfo;
import software.amazon.awssdk.services.inspector2.model.AwsEksWorkloadInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEksMetadataDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEksMetadataDetails> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(AwsEksMetadataDetails.getter(AwsEksMetadataDetails::namespace)).setter(AwsEksMetadataDetails.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<List<AwsEksWorkloadInfo>> WORKLOAD_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workloadInfoList").getter(AwsEksMetadataDetails.getter(AwsEksMetadataDetails::workloadInfoList)).setter(AwsEksMetadataDetails.setter(Builder::workloadInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEksWorkloadInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, WORKLOAD_INFO_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsEksMetadataDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final List<AwsEksWorkloadInfo> workloadInfoList;

    private AwsEksMetadataDetails(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.workloadInfoList = builder.workloadInfoList;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final boolean hasWorkloadInfoList() {
        return this.workloadInfoList != null && !(this.workloadInfoList instanceof SdkAutoConstructList);
    }

    public final List<AwsEksWorkloadInfo> workloadInfoList() {
        return this.workloadInfoList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkloadInfoList() ? this.workloadInfoList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEksMetadataDetails)) {
            return false;
        }
        AwsEksMetadataDetails other = (AwsEksMetadataDetails)obj;
        return Objects.equals(this.namespace(), other.namespace()) && this.hasWorkloadInfoList() == other.hasWorkloadInfoList() && Objects.equals(this.workloadInfoList(), other.workloadInfoList());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEksMetadataDetails").add("Namespace", (Object)this.namespace()).add("WorkloadInfoList", this.hasWorkloadInfoList() ? this.workloadInfoList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "workloadInfoList": {
                return Optional.ofNullable(clazz.cast(this.workloadInfoList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("namespace", NAMESPACE_FIELD);
        map.put("workloadInfoList", WORKLOAD_INFO_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEksMetadataDetails, T> g) {
        return obj -> g.apply((AwsEksMetadataDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespace;
        private List<AwsEksWorkloadInfo> workloadInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEksMetadataDetails model) {
            this.namespace(model.namespace);
            this.workloadInfoList(model.workloadInfoList);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final List<AwsEksWorkloadInfo.Builder> getWorkloadInfoList() {
            List<AwsEksWorkloadInfo.Builder> result = AwsEksWorkloadInfoListCopier.copyToBuilder(this.workloadInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkloadInfoList(Collection<AwsEksWorkloadInfo.BuilderImpl> workloadInfoList) {
            this.workloadInfoList = AwsEksWorkloadInfoListCopier.copyFromBuilder(workloadInfoList);
        }

        @Override
        public final Builder workloadInfoList(Collection<AwsEksWorkloadInfo> workloadInfoList) {
            this.workloadInfoList = AwsEksWorkloadInfoListCopier.copy(workloadInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadInfoList(AwsEksWorkloadInfo ... workloadInfoList) {
            this.workloadInfoList(Arrays.asList(workloadInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadInfoList(Consumer<AwsEksWorkloadInfo.Builder> ... workloadInfoList) {
            this.workloadInfoList(Stream.of(workloadInfoList).map(c -> (AwsEksWorkloadInfo)((AwsEksWorkloadInfo.Builder)AwsEksWorkloadInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsEksMetadataDetails build() {
            return new AwsEksMetadataDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEksMetadataDetails> {
        public Builder namespace(String var1);

        public Builder workloadInfoList(Collection<AwsEksWorkloadInfo> var1);

        public Builder workloadInfoList(AwsEksWorkloadInfo ... var1);

        public Builder workloadInfoList(Consumer<AwsEksWorkloadInfo.Builder> ... var1);
    }
}

