/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AggregationType {
    FINDING_TYPE("FINDING_TYPE"),
    PACKAGE("PACKAGE"),
    TITLE("TITLE"),
    REPOSITORY("REPOSITORY"),
    AMI("AMI"),
    AWS_EC2_INSTANCE("AWS_EC2_INSTANCE"),
    AWS_ECR_CONTAINER("AWS_ECR_CONTAINER"),
    IMAGE_LAYER("IMAGE_LAYER"),
    ACCOUNT("ACCOUNT"),
    AWS_LAMBDA_FUNCTION("AWS_LAMBDA_FUNCTION"),
    LAMBDA_LAYER("LAMBDA_LAYER"),
    CODE_REPOSITORY("CODE_REPOSITORY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AggregationType> VALUE_MAP;
    private final String value;

    private AggregationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AggregationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AggregationType> knownValues() {
        EnumSet<AggregationType> knownValues = EnumSet.allOf(AggregationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AggregationType.class, AggregationType::toString);
    }
}

