/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2AsyncClient;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse;
import software.amazon.awssdk.services.inspector2.model.Vulnerability;

public class SearchVulnerabilitiesPublisher
implements SdkPublisher<SearchVulnerabilitiesResponse> {
    private final Inspector2AsyncClient client;
    private final SearchVulnerabilitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchVulnerabilitiesPublisher(Inspector2AsyncClient client, SearchVulnerabilitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchVulnerabilitiesPublisher(Inspector2AsyncClient client, SearchVulnerabilitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchVulnerabilitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchVulnerabilitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Vulnerability> vulnerabilities() {
        Function<SearchVulnerabilitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.vulnerabilities() != null) {
                return response.vulnerabilities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchVulnerabilitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchVulnerabilitiesResponseFetcher
    implements AsyncPageFetcher<SearchVulnerabilitiesResponse> {
        private SearchVulnerabilitiesResponseFetcher() {
        }

        public boolean hasNextPage(SearchVulnerabilitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchVulnerabilitiesResponse> nextPage(SearchVulnerabilitiesResponse previousPage) {
            if (previousPage == null) {
                return SearchVulnerabilitiesPublisher.this.client.searchVulnerabilities(SearchVulnerabilitiesPublisher.this.firstRequest);
            }
            return SearchVulnerabilitiesPublisher.this.client.searchVulnerabilities((SearchVulnerabilitiesRequest)((Object)SearchVulnerabilitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

