/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.DelegatedAdminAccount;
import software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest;
import software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse;

public class ListDelegatedAdminAccountsIterable
implements SdkIterable<ListDelegatedAdminAccountsResponse> {
    private final Inspector2Client client;
    private final ListDelegatedAdminAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDelegatedAdminAccountsIterable(Inspector2Client client, ListDelegatedAdminAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDelegatedAdminAccountsResponseFetcher();
    }

    public Iterator<ListDelegatedAdminAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DelegatedAdminAccount> delegatedAdminAccounts() {
        Function<ListDelegatedAdminAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.delegatedAdminAccounts() != null) {
                return response.delegatedAdminAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDelegatedAdminAccountsResponseFetcher
    implements SyncPageFetcher<ListDelegatedAdminAccountsResponse> {
        private ListDelegatedAdminAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListDelegatedAdminAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDelegatedAdminAccountsResponse nextPage(ListDelegatedAdminAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListDelegatedAdminAccountsIterable.this.client.listDelegatedAdminAccounts(ListDelegatedAdminAccountsIterable.this.firstRequest);
            }
            return ListDelegatedAdminAccountsIterable.this.client.listDelegatedAdminAccounts((ListDelegatedAdminAccountsRequest)((Object)ListDelegatedAdminAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

