/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2AsyncClient;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.ClusterInformation;
import software.amazon.awssdk.services.inspector2.model.GetClustersForImageRequest;
import software.amazon.awssdk.services.inspector2.model.GetClustersForImageResponse;

public class GetClustersForImagePublisher
implements SdkPublisher<GetClustersForImageResponse> {
    private final Inspector2AsyncClient client;
    private final GetClustersForImageRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetClustersForImagePublisher(Inspector2AsyncClient client, GetClustersForImageRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetClustersForImagePublisher(Inspector2AsyncClient client, GetClustersForImageRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetClustersForImageResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetClustersForImageResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClusterInformation> cluster() {
        Function<GetClustersForImageResponse, Iterator> getIterator = response -> {
            if (response != null && response.cluster() != null) {
                return response.cluster().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetClustersForImageResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetClustersForImageResponseFetcher
    implements AsyncPageFetcher<GetClustersForImageResponse> {
        private GetClustersForImageResponseFetcher() {
        }

        public boolean hasNextPage(GetClustersForImageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetClustersForImageResponse> nextPage(GetClustersForImageResponse previousPage) {
            if (previousPage == null) {
                return GetClustersForImagePublisher.this.client.getClustersForImage(GetClustersForImagePublisher.this.firstRequest);
            }
            return GetClustersForImagePublisher.this.client.getClustersForImage((GetClustersForImageRequest)((Object)GetClustersForImagePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

