/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UsageType {
    EC2_INSTANCE_HOURS("EC2_INSTANCE_HOURS"),
    ECR_INITIAL_SCAN("ECR_INITIAL_SCAN"),
    ECR_RESCAN("ECR_RESCAN"),
    LAMBDA_FUNCTION_HOURS("LAMBDA_FUNCTION_HOURS"),
    LAMBDA_FUNCTION_CODE_HOURS("LAMBDA_FUNCTION_CODE_HOURS"),
    CODE_REPOSITORY_SAST("CODE_REPOSITORY_SAST"),
    CODE_REPOSITORY_IAC("CODE_REPOSITORY_IAC"),
    CODE_REPOSITORY_SCA("CODE_REPOSITORY_SCA"),
    EC2_AGENTLESS_INSTANCE_HOURS("EC2_AGENTLESS_INSTANCE_HOURS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UsageType> VALUE_MAP;
    private final String value;

    private UsageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UsageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UsageType> knownValues() {
        EnumSet<UsageType> knownValues = EnumSet.allOf(UsageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UsageType.class, UsageType::toString);
    }
}

