/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.services.inspector2.model.IntegrationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCodeSecurityIntegrationResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, UpdateCodeSecurityIntegrationResponse> {
    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationArn").getter(UpdateCodeSecurityIntegrationResponse.getter(UpdateCodeSecurityIntegrationResponse::integrationArn)).setter(UpdateCodeSecurityIntegrationResponse.setter(Builder::integrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateCodeSecurityIntegrationResponse.getter(UpdateCodeSecurityIntegrationResponse::statusAsString)).setter(UpdateCodeSecurityIntegrationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_ARN_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCodeSecurityIntegrationResponse.memberNameToFieldInitializer();
    private final String integrationArn;
    private final String status;

    private UpdateCodeSecurityIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.integrationArn = builder.integrationArn;
        this.status = builder.status;
    }

    public final String integrationArn() {
        return this.integrationArn;
    }

    public final IntegrationStatus status() {
        return IntegrationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCodeSecurityIntegrationResponse)) {
            return false;
        }
        UpdateCodeSecurityIntegrationResponse other = (UpdateCodeSecurityIntegrationResponse)((Object)obj);
        return Objects.equals(this.integrationArn(), other.integrationArn()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCodeSecurityIntegrationResponse").add("IntegrationArn", (Object)this.integrationArn()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "integrationArn": {
                return Optional.ofNullable(clazz.cast(this.integrationArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("integrationArn", INTEGRATION_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCodeSecurityIntegrationResponse, T> g) {
        return obj -> g.apply((UpdateCodeSecurityIntegrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private String integrationArn;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCodeSecurityIntegrationResponse model) {
            super(model);
            this.integrationArn(model.integrationArn);
            this.status(model.status);
        }

        public final String getIntegrationArn() {
            return this.integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IntegrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public UpdateCodeSecurityIntegrationResponse build() {
            return new UpdateCodeSecurityIntegrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCodeSecurityIntegrationResponse> {
        public Builder integrationArn(String var1);

        public Builder status(String var1);

        public Builder status(IntegrationStatus var1);
    }
}

