/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SortField {
    AWS_ACCOUNT_ID("AWS_ACCOUNT_ID"),
    FINDING_TYPE("FINDING_TYPE"),
    SEVERITY("SEVERITY"),
    FIRST_OBSERVED_AT("FIRST_OBSERVED_AT"),
    LAST_OBSERVED_AT("LAST_OBSERVED_AT"),
    FINDING_STATUS("FINDING_STATUS"),
    RESOURCE_TYPE("RESOURCE_TYPE"),
    ECR_IMAGE_PUSHED_AT("ECR_IMAGE_PUSHED_AT"),
    ECR_IMAGE_REPOSITORY_NAME("ECR_IMAGE_REPOSITORY_NAME"),
    ECR_IMAGE_REGISTRY("ECR_IMAGE_REGISTRY"),
    NETWORK_PROTOCOL("NETWORK_PROTOCOL"),
    COMPONENT_TYPE("COMPONENT_TYPE"),
    VULNERABILITY_ID("VULNERABILITY_ID"),
    VULNERABILITY_SOURCE("VULNERABILITY_SOURCE"),
    INSPECTOR_SCORE("INSPECTOR_SCORE"),
    VENDOR_SEVERITY("VENDOR_SEVERITY"),
    EPSS_SCORE("EPSS_SCORE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SortField> VALUE_MAP;
    private final String value;

    private SortField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SortField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SortField> knownValues() {
        EnumSet<SortField> knownValues = EnumSet.allOf(SortField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SortField.class, SortField::toString);
    }
}

