/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CodeScanStatus {
    IN_PROGRESS("IN_PROGRESS"),
    SUCCESSFUL("SUCCESSFUL"),
    FAILED("FAILED"),
    SKIPPED("SKIPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CodeScanStatus> VALUE_MAP;
    private final String value;

    private CodeScanStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CodeScanStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CodeScanStatus> knownValues() {
        EnumSet<CodeScanStatus> knownValues = EnumSet.allOf(CodeScanStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CodeScanStatus.class, CodeScanStatus::toString);
    }
}

