/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.FreeTrialAccountInfo;
import software.amazon.awssdk.services.inspector2.model.FreeTrialAccountInfoListCopier;
import software.amazon.awssdk.services.inspector2.model.FreeTrialInfoError;
import software.amazon.awssdk.services.inspector2.model.FreeTrialInfoErrorListCopier;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetFreeTrialInfoResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, BatchGetFreeTrialInfoResponse> {
    private static final SdkField<List<FreeTrialAccountInfo>> ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accounts").getter(BatchGetFreeTrialInfoResponse.getter(BatchGetFreeTrialInfoResponse::accounts)).setter(BatchGetFreeTrialInfoResponse.setter(Builder::accounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FreeTrialAccountInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FreeTrialInfoError>> FAILED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedAccounts").getter(BatchGetFreeTrialInfoResponse.getter(BatchGetFreeTrialInfoResponse::failedAccounts)).setter(BatchGetFreeTrialInfoResponse.setter(Builder::failedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FreeTrialInfoError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD, FAILED_ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetFreeTrialInfoResponse.memberNameToFieldInitializer();
    private final List<FreeTrialAccountInfo> accounts;
    private final List<FreeTrialInfoError> failedAccounts;

    private BatchGetFreeTrialInfoResponse(BuilderImpl builder) {
        super(builder);
        this.accounts = builder.accounts;
        this.failedAccounts = builder.failedAccounts;
    }

    public final boolean hasAccounts() {
        return this.accounts != null && !(this.accounts instanceof SdkAutoConstructList);
    }

    public final List<FreeTrialAccountInfo> accounts() {
        return this.accounts;
    }

    public final boolean hasFailedAccounts() {
        return this.failedAccounts != null && !(this.failedAccounts instanceof SdkAutoConstructList);
    }

    public final List<FreeTrialInfoError> failedAccounts() {
        return this.failedAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccounts() ? this.accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedAccounts() ? this.failedAccounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFreeTrialInfoResponse)) {
            return false;
        }
        BatchGetFreeTrialInfoResponse other = (BatchGetFreeTrialInfoResponse)((Object)obj);
        return this.hasAccounts() == other.hasAccounts() && Objects.equals(this.accounts(), other.accounts()) && this.hasFailedAccounts() == other.hasFailedAccounts() && Objects.equals(this.failedAccounts(), other.failedAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetFreeTrialInfoResponse").add("Accounts", this.hasAccounts() ? this.accounts() : null).add("FailedAccounts", this.hasFailedAccounts() ? this.failedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accounts": {
                return Optional.ofNullable(clazz.cast(this.accounts()));
            }
            case "failedAccounts": {
                return Optional.ofNullable(clazz.cast(this.failedAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accounts", ACCOUNTS_FIELD);
        map.put("failedAccounts", FAILED_ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFreeTrialInfoResponse, T> g) {
        return obj -> g.apply((BatchGetFreeTrialInfoResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private List<FreeTrialAccountInfo> accounts = DefaultSdkAutoConstructList.getInstance();
        private List<FreeTrialInfoError> failedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFreeTrialInfoResponse model) {
            super(model);
            this.accounts(model.accounts);
            this.failedAccounts(model.failedAccounts);
        }

        public final List<FreeTrialAccountInfo.Builder> getAccounts() {
            List<FreeTrialAccountInfo.Builder> result = FreeTrialAccountInfoListCopier.copyToBuilder(this.accounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccounts(Collection<FreeTrialAccountInfo.BuilderImpl> accounts) {
            this.accounts = FreeTrialAccountInfoListCopier.copyFromBuilder(accounts);
        }

        @Override
        public final Builder accounts(Collection<FreeTrialAccountInfo> accounts) {
            this.accounts = FreeTrialAccountInfoListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(FreeTrialAccountInfo ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Consumer<FreeTrialAccountInfo.Builder> ... accounts) {
            this.accounts(Stream.of(accounts).map(c -> (FreeTrialAccountInfo)((FreeTrialAccountInfo.Builder)FreeTrialAccountInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FreeTrialInfoError.Builder> getFailedAccounts() {
            List<FreeTrialInfoError.Builder> result = FreeTrialInfoErrorListCopier.copyToBuilder(this.failedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedAccounts(Collection<FreeTrialInfoError.BuilderImpl> failedAccounts) {
            this.failedAccounts = FreeTrialInfoErrorListCopier.copyFromBuilder(failedAccounts);
        }

        @Override
        public final Builder failedAccounts(Collection<FreeTrialInfoError> failedAccounts) {
            this.failedAccounts = FreeTrialInfoErrorListCopier.copy(failedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAccounts(FreeTrialInfoError ... failedAccounts) {
            this.failedAccounts(Arrays.asList(failedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAccounts(Consumer<FreeTrialInfoError.Builder> ... failedAccounts) {
            this.failedAccounts(Stream.of(failedAccounts).map(c -> (FreeTrialInfoError)((FreeTrialInfoError.Builder)FreeTrialInfoError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetFreeTrialInfoResponse build() {
            return new BatchGetFreeTrialInfoResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetFreeTrialInfoResponse> {
        public Builder accounts(Collection<FreeTrialAccountInfo> var1);

        public Builder accounts(FreeTrialAccountInfo ... var1);

        public Builder accounts(Consumer<FreeTrialAccountInfo.Builder> ... var1);

        public Builder failedAccounts(Collection<FreeTrialInfoError> var1);

        public Builder failedAccounts(FreeTrialInfoError ... var1);

        public Builder failedAccounts(Consumer<FreeTrialInfoError.Builder> ... var1);
    }
}

