/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2AsyncClient;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.AggregationResponse;
import software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest;
import software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse;

public class ListFindingAggregationsPublisher
implements SdkPublisher<ListFindingAggregationsResponse> {
    private final Inspector2AsyncClient client;
    private final ListFindingAggregationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFindingAggregationsPublisher(Inspector2AsyncClient client, ListFindingAggregationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFindingAggregationsPublisher(Inspector2AsyncClient client, ListFindingAggregationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFindingAggregationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFindingAggregationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AggregationResponse> responses() {
        Function<ListFindingAggregationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.responses() != null) {
                return response.responses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFindingAggregationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFindingAggregationsResponseFetcher
    implements AsyncPageFetcher<ListFindingAggregationsResponse> {
        private ListFindingAggregationsResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingAggregationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFindingAggregationsResponse> nextPage(ListFindingAggregationsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingAggregationsPublisher.this.client.listFindingAggregations(ListFindingAggregationsPublisher.this.firstRequest);
            }
            return ListFindingAggregationsPublisher.this.client.listFindingAggregations((ListFindingAggregationsRequest)((Object)ListFindingAggregationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

