/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2AsyncClient;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.CisTargetResourceAggregation;
import software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse;

public class ListCisScanResultsAggregatedByTargetResourcePublisher
implements SdkPublisher<ListCisScanResultsAggregatedByTargetResourceResponse> {
    private final Inspector2AsyncClient client;
    private final ListCisScanResultsAggregatedByTargetResourceRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCisScanResultsAggregatedByTargetResourcePublisher(Inspector2AsyncClient client, ListCisScanResultsAggregatedByTargetResourceRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCisScanResultsAggregatedByTargetResourcePublisher(Inspector2AsyncClient client, ListCisScanResultsAggregatedByTargetResourceRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCisScanResultsAggregatedByTargetResourceResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCisScanResultsAggregatedByTargetResourceResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CisTargetResourceAggregation> targetResourceAggregations() {
        Function<ListCisScanResultsAggregatedByTargetResourceResponse, Iterator> getIterator = response -> {
            if (response != null && response.targetResourceAggregations() != null) {
                return response.targetResourceAggregations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCisScanResultsAggregatedByTargetResourceResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCisScanResultsAggregatedByTargetResourceResponseFetcher
    implements AsyncPageFetcher<ListCisScanResultsAggregatedByTargetResourceResponse> {
        private ListCisScanResultsAggregatedByTargetResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListCisScanResultsAggregatedByTargetResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCisScanResultsAggregatedByTargetResourceResponse> nextPage(ListCisScanResultsAggregatedByTargetResourceResponse previousPage) {
            if (previousPage == null) {
                return ListCisScanResultsAggregatedByTargetResourcePublisher.this.client.listCisScanResultsAggregatedByTargetResource(ListCisScanResultsAggregatedByTargetResourcePublisher.this.firstRequest);
            }
            return ListCisScanResultsAggregatedByTargetResourcePublisher.this.client.listCisScanResultsAggregatedByTargetResource((ListCisScanResultsAggregatedByTargetResourceRequest)((Object)ListCisScanResultsAggregatedByTargetResourcePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

