/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputePlatform
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputePlatform> {
    private static final SdkField<String> PRODUCT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("product").getter(ComputePlatform.getter(ComputePlatform::product)).setter(ComputePlatform.setter(Builder::product)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("product").build()}).build();
    private static final SdkField<String> VENDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vendor").getter(ComputePlatform.getter(ComputePlatform::vendor)).setter(ComputePlatform.setter(Builder::vendor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendor").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(ComputePlatform.getter(ComputePlatform::version)).setter(ComputePlatform.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_FIELD, VENDOR_FIELD, VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String product;
    private final String vendor;
    private final String version;

    private ComputePlatform(BuilderImpl builder) {
        this.product = builder.product;
        this.vendor = builder.vendor;
        this.version = builder.version;
    }

    public final String product() {
        return this.product;
    }

    public final String vendor() {
        return this.vendor;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.product());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendor());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputePlatform)) {
            return false;
        }
        ComputePlatform other = (ComputePlatform)obj;
        return Objects.equals(this.product(), other.product()) && Objects.equals(this.vendor(), other.vendor()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"ComputePlatform").add("Product", (Object)this.product()).add("Vendor", (Object)this.vendor()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "product": {
                return Optional.ofNullable(clazz.cast(this.product()));
            }
            case "vendor": {
                return Optional.ofNullable(clazz.cast(this.vendor()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputePlatform, T> g) {
        return obj -> g.apply((ComputePlatform)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String product;
        private String vendor;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputePlatform model) {
            this.product(model.product);
            this.vendor(model.vendor);
            this.version(model.version);
        }

        public final String getProduct() {
            return this.product;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        @Override
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        public final String getVendor() {
            return this.vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public ComputePlatform build() {
            return new ComputePlatform(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputePlatform> {
        public Builder product(String var1);

        public Builder vendor(String var1);

        public Builder version(String var1);
    }
}

